/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import jakarta.annotation.Resource;
import java.util.Set;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateSnapshotOptions;
import org.jclouds.cloudstack.options.ListSnapshotsOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.logging.Logger;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SnapshotApiLiveTest")
public class SnapshotApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Resource
    Logger logger = Logger.NULL;

    public void testListSnapshots() {
        Set snapshots = this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[0]);
        AssertJUnit.assertNotNull((Object)snapshots);
        AssertJUnit.assertFalse((boolean)snapshots.isEmpty());
        for (Snapshot snapshot : snapshots) {
            this.checkSnapshot(snapshot);
        }
    }

    public void testListSnapshotsById() {
        Iterable snapshotIds = Iterables.transform((Iterable)this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[0]), (Function)new Function<Snapshot, String>(){

            public String apply(Snapshot input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)snapshotIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)snapshotIds));
        for (String id : snapshotIds) {
            Set found = this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[]{ListSnapshotsOptions.Builder.id((String)id)});
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)1, (int)found.size());
            Snapshot snapshot = (Snapshot)Iterables.getOnlyElement((Iterable)found);
            AssertJUnit.assertEquals((String)id, (String)snapshot.getId());
            this.checkSnapshot(snapshot);
        }
    }

    public void testListSnapshotsNonexistantId() {
        Set found = this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[]{ListSnapshotsOptions.Builder.id((String)"foo")});
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertTrue((boolean)found.isEmpty());
    }

    public void testGetSnapshotById() {
        Iterable snapshotIds = Iterables.transform((Iterable)this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[0]), (Function)new Function<Snapshot, String>(){

            public String apply(Snapshot input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)snapshotIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)snapshotIds));
        for (String id : snapshotIds) {
            Snapshot found = this.client.getSnapshotApi().getSnapshot(id);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((String)id, (String)found.getId());
            this.checkSnapshot(found);
        }
    }

    public void testGetSnapshotNonexistantId() {
        Snapshot found = this.client.getSnapshotApi().getSnapshot("foo");
        AssertJUnit.assertNull((Object)found);
    }

    protected Volume getPreferredVolume() {
        for (Volume candidate : this.client.getVolumeApi().listVolumes(new ListVolumesOptions[0])) {
            if (candidate.getState() != Volume.State.READY) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable Volume found.");
    }

    public void testCreateSnapshotFromVolume() {
        Volume volume = this.getPreferredVolume();
        this.logger.info("creating snapshot from volume %s", new Object[]{volume});
        AsyncCreateResponse job = this.client.getSnapshotApi().createSnapshot(volume.getId(), new CreateSnapshotOptions[0]);
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        Snapshot snapshot = this.findSnapshotWithId(job.getId());
        this.logger.info("created snapshot %s from volume %s", new Object[]{snapshot, volume});
        this.checkSnapshot(snapshot);
        this.client.getSnapshotApi().deleteSnapshot(snapshot.getId());
    }

    private void checkSnapshot(Snapshot snapshot) {
        AssertJUnit.assertNotNull((Object)snapshot.getId());
        AssertJUnit.assertNotNull((Object)snapshot.getName());
        AssertJUnit.assertNotSame((Object)Snapshot.Type.UNRECOGNIZED, (Object)snapshot.getSnapshotType());
    }

    private Snapshot findSnapshotWithId(final String id) {
        return (Snapshot)Iterables.find((Iterable)this.client.getSnapshotApi().listSnapshots(new ListSnapshotsOptions[0]), (Predicate)new Predicate<Snapshot>(){

            public boolean apply(Snapshot arg0) {
                return arg0.getId().equals(id);
            }
        });
    }
}

