/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.EncryptedPasswordAndPrivateKey;
import org.jclouds.cloudstack.features.VirtualMachineApi;
import org.jclouds.cloudstack.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.crypto.Crypto;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VirtualMachineApiExpectTest")
public class VirtualMachineApiExpectTest
extends BaseCloudStackExpectTest<VirtualMachineApi> {
    HttpRequest deployVirtualMachineInZone = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"zone1"}).addQueryParam("serviceofferingid", new String[]{"serviceOffering1"}).addQueryParam("templateid", new String[]{"template1"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"pBjjnTq7/ezN94Uj0gpy2T//cJQ="}).addHeader("Accept", new String[]{"application/json"})).build();

    public void testGetPasswordForVirtualMachineWhenResponseIs2xx() throws NoSuchAlgorithmException, CertificateException {
        String privateKey = "-----BEGIN RSA PRIVATE KEY-----\nMIICXgIBAAKBgQDnaPKhTNgw7qPJVp3qsT+7XhhAbip25a0AnUgq8Fb9LPcZk00p\njm+m4JrKmDWKZWrHMNBhCNHMzvV9KrAXUMzL4s7mdEicbxTKratTYoyJM7a87bcZ\nxr+Gtoq4tm031Cix3LKyJUB0iSVU5V/Zx4QcaF5+FWcYMVI26x2Eaz+O7wIDAQAB\nAoGBAOI8sDkSL6pnJKmKjQkOEQjVjVAwZEOpd+HJ4uxX3DPY6huO7zlZj77Oh4ba\nGD4duK7VAmRbgwGAtHCSc2XYEN7ICnfkQrm+3Q8nS824Sz21WlzdCxKDFkDcC1wK\nRjE7SwXN1Kj8Xq8Vpf+z6OzHatSRZD85JM3u0/QCksOJTVIBAkEA9OpycYTuUYjC\n2pLrO5kkl0nIHbNPvFNZyle19AsHH0z/ClV8DiFtGQpwhqwCoWT0cTmSACPD/quA\nhdc2mvV+4QJBAPHiBi/7qDpJldLLvK5ALbn1yRaPSDXLccvFV4FkSS9b/2+mOM2a\n8JkolVCzImxAm0ZZDZeAGKJj1RZDsMIP188CQCfZKWus7DWZ4dI8S0e0IA75czTZ\n4uRKT3arlLAzRyJhnbFpvThzWdPULgDLZdYqndb6PfYF27LI5q1gGcNWpCECQQCB\nr8/ldiZyafW8eaQGQT7DD7brM5Nh1FyFBp+uLljW3ZqNADBAfKw3Uf0MsZ7pL5KR\nGzogWnvaxXAAafahdeEdAkEAzBT+UcxFmcPUO33PnuuiX5KIqThc6aHjjH5O7yzO\nm4Et9JwQiSgcPBmNY5NKPgmcpvUi9jDylSUV0VUu436RpQ==\n-----END RSA PRIVATE KEY-----";
        VirtualMachineApi client = (VirtualMachineApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"getVMPassword"}).addQueryParam("id", new String[]{"1"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"SVA2r1KRj4yG03rATMLPZWS+Knw="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getvmpasswordresponse.json"))).build());
        String actual = client.getEncryptedPasswordForVirtualMachine("1");
        String expected = "EFOwm8icZ4sEib4y6ntVHUKHZJQrGBdyPkL1L9lpFHYhs3JfAtL5E5bxBP5Er27bJyOZPjKFcInX\r\npQ0LZlQBZDd5/ac0NSoM6tAX3H30pYxNw4t2f9u8aJ48oOEvufgGxTTHnM9qHXD04lt+Ouql6i2q\r\nHxBqCxFkMZEla3LFieE=\r\n";
        Assert.assertEquals((String)actual, (String)expected);
        WindowsLoginCredentialsFromEncryptedData passwordDecrypt = new WindowsLoginCredentialsFromEncryptedData((Crypto)new JCECrypto());
        Assert.assertEquals((String)((String)passwordDecrypt.apply(EncryptedPasswordAndPrivateKey.builder().encryptedPassword(actual).privateKey(privateKey).build()).getOptionalPassword().get()), (String)"bX7vvptvw");
    }

    public void testDeployVirtualMachineIs2xxVersion3x() {
        HttpResponse deployVirtualMachineInZoneResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deployvirtualmachineresponse.json"))).build();
        VirtualMachineApi client = (VirtualMachineApi)this.requestSendsResponse(this.deployVirtualMachineInZone, deployVirtualMachineInZoneResponse);
        AsyncCreateResponse async = client.deployVirtualMachineInZone("zone1", "serviceOffering1", "template1", new DeployVirtualMachineOptions[0]);
        Assert.assertEquals((Object)async, (Object)AsyncCreateResponse.builder().id("1234").jobId("50006").build());
    }

    public void testDeployVirtualMachineIs2xxVersion4x() {
        HttpResponse deployVirtualMachineInZoneResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deployvirtualmachineresponse4x.json"))).build();
        VirtualMachineApi client = (VirtualMachineApi)this.requestSendsResponse(this.deployVirtualMachineInZone, deployVirtualMachineInZoneResponse);
        AsyncCreateResponse async = client.deployVirtualMachineInZone("zone1", "serviceOffering1", "template1", new DeployVirtualMachineOptions[0]);
        Assert.assertEquals((Object)async, (Object)AsyncCreateResponse.builder().id("1cce6cb7-2268-47ff-9696-d9e610f6619a").jobId("13330fc9-8b3e-4582-aa3e-90883c041ff0").build());
    }

    @Override
    protected VirtualMachineApi clientFrom(CloudStackContext context) {
        return context.getApi().getVirtualMachineApi();
    }
}

