/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.features.VolumeApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeApiExpectTest")
public class VolumeApiExpectTest
extends BaseCloudStackExpectTest<VolumeApi> {
    public void testCreateVolumeFromCustomDiskOffering() throws NoSuchAlgorithmException, CertificateException {
        VolumeApi client = (VolumeApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createVolume&name=VolumeApiExpectTest-jclouds-volume&diskofferingid=0473f5dd-bca5-4af4-a9b6-db9e8a88a2f6&zoneid=6f9a2921-b22a-4149-8b71-6ffc275a2177&size=1&apiKey=identity&signature=%2BoEjGobVFLr58k19LeAE81bZkKM%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-createvolume.json"))).build());
        AsyncCreateResponse response = client.createVolumeFromCustomDiskOfferingInZone("VolumeApiExpectTest-jclouds-volume", "0473f5dd-bca5-4af4-a9b6-db9e8a88a2f6", "6f9a2921-b22a-4149-8b71-6ffc275a2177", 1);
        Assert.assertNotNull((Object)response);
    }

    @Override
    protected VolumeApi clientFrom(CloudStackContext context) {
        return context.getApi().getVolumeApi();
    }
}

