/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.AsyncJobException;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.features.AsyncJobApi;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class JobCompleteTest {
    CloudStackApi client;
    AsyncJobApi asyncJobClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        this.asyncJobClient = (AsyncJobApi)EasyMock.createMock(AsyncJobApi.class);
        EasyMock.expect((Object)this.client.getAsyncJobApi()).andReturn((Object)this.asyncJobClient);
    }

    @Test
    public void testJobComplete() {
        AsyncJob job = AsyncJob.builder().id("100").status(AsyncJob.Status.SUCCEEDED).resultCode(AsyncJob.ResultCode.SUCCESS).build();
        EasyMock.expect((Object)this.asyncJobClient.getAsyncJob(job.getId())).andReturn((Object)job);
        EasyMock.replay((Object[])new Object[]{this.client, this.asyncJobClient});
        Assert.assertTrue((boolean)new JobComplete(this.client).apply(job.getId()));
        EasyMock.verify((Object[])new Object[]{this.client, this.asyncJobClient});
    }

    @Test
    public void testFailedJobComplete() {
        AsyncJob job = AsyncJob.builder().id("100").status(AsyncJob.Status.FAILED).resultCode(AsyncJob.ResultCode.FAIL).error(AsyncJobError.builder().errorCode(AsyncJobError.ErrorCode.INTERNAL_ERROR).errorText("Dummy test error").build()).build();
        EasyMock.expect((Object)this.asyncJobClient.getAsyncJob(job.getId())).andReturn((Object)job);
        EasyMock.replay((Object[])new Object[]{this.client, this.asyncJobClient});
        try {
            new JobComplete(this.client).apply(job.getId());
            Assert.fail((String)"No exception thrown");
        }
        catch (AsyncJobException e) {
            Assert.assertTrue((boolean)e.toString().contains("Dummy test error"));
        }
        EasyMock.verify((Object[])new Object[]{this.client, this.asyncJobClient});
    }
}

