/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Strings;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListClustersOptions;
import org.jclouds.cloudstack.options.ListHostsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalHostApiLiveTest")
public class GlobalHostApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListHosts() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set hosts = this.globalAdminClient.getHostClient().listHosts(new ListHostsOptions[0]);
        assert (!hosts.isEmpty()) : hosts;
        for (Host host : hosts) {
            this.checkHost(host);
        }
    }

    private void checkHost(Host host) {
        if (host.getType() == Host.Type.ROUTING) {
            assert (host.getCpuNumber() > 0);
            assert (host.getAverageLoad() >= 0);
            assert (host.getHypervisor() != null);
        }
        assert (host.getEvents() != null);
        if (host.getType() == Host.Type.SECONDARY_STORAGE_VM) assert (host.getName().startsWith("s-"));
        if (host.getType() == Host.Type.CONSOLE_PROXY) assert (host.getName().startsWith("v-"));
    }

    @Test(groups={"live"}, enabled=true)
    public void testListClusters() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set clusters = this.globalAdminClient.getHostClient().listClusters(new ListClustersOptions[0]);
        assert (!clusters.isEmpty()) : clusters;
        for (Cluster cluster : clusters) {
            this.checkCluster(cluster);
        }
    }

    private void checkCluster(Cluster cluster) {
        Assert.assertNotNull((Object)cluster.getId());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getName()));
        Assert.assertNotEquals((Object)AllocationState.UNKNOWN, (Object)cluster.getAllocationState());
        Assert.assertNotEquals((Object)Host.ClusterType.UNKNOWN, (Object)cluster.getClusterType());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getHypervisor()));
        Assert.assertNotEquals((Object)Cluster.ManagedState.UNRECOGNIZED, (Object)cluster.getManagedState());
        Assert.assertNotNull((Object)cluster.getPodId());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getPodName()));
        Assert.assertNotNull((Object)cluster.getZoneId());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getZoneName()));
    }
}

