/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.features.VolumeApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeApiTest")
public class VolumeApiTest
extends BaseCloudStackApiTest<VolumeApi> {
    HttpRequest createVolumeFromSnapshot = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createVolume"}).addQueryParam("name", new String[]{"jclouds-volume"}).addQueryParam("snapshotid", new String[]{"999"}).addQueryParam("zoneid", new String[]{"111"}).build();
    HttpRequest createVolumeFromDiskOffering = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createVolume"}).addQueryParam("name", new String[]{"jclouds-volume"}).addQueryParam("diskofferingid", new String[]{"999"}).addQueryParam("zoneid", new String[]{"111"}).build();

    public void testListVolumes() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"listVolumes", (Class[])new Class[]{ListVolumesOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listVolumes&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"getVolume", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)111L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listVolumes&listAll=true&id=111 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVolumeWithSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"createVolumeFromSnapshotInZone", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"jclouds-volume", (Object)999L, (Object)111L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.createVolumeFromSnapshot.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVolumeFromDiskOffering() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"createVolumeFromDiskOfferingInZone", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"jclouds-volume", (Object)999L, (Object)111L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.createVolumeFromDiskOffering.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAttachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"attachVolume", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)111L, (Object)999L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=attachVolume&id=111&virtualmachineid=999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDetachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"detachVolume", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)111L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=detachVolume&id=111 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VolumeApi.class, (String)"deleteVolume", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)111L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteVolume&id=111 HTTP/1.1");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

