/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.internal;

import com.google.inject.Module;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.config.CloudStackHttpApiModule;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestAnnotationProcessingTest;
import org.testng.Assert;

public abstract class BaseCloudStackApiTest<T>
extends BaseRestAnnotationProcessingTest<T> {
    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), QuerySigner.class);
    }

    protected Module createModule() {
        return new CloudStackHttpApiModuleExtension();
    }

    protected ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forApiWithEndpoint((ApiMetadata)new CloudStackApiMetadata(), (String)"http://localhost:8080/client/api");
    }

    @ConfiguresHttpApi
    public static class CloudStackHttpApiModuleExtension
    extends CloudStackHttpApiModule {
    }
}

