/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.options.DeleteTagsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DeleteTagsOptionsTest {
    public void testResourceIds() {
        DeleteTagsOptions options = new DeleteTagsOptions().resourceIds(new String[]{"1", "2", "3"});
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsStatic() {
        DeleteTagsOptions options = DeleteTagsOptions.Builder.resourceIds((String[])new String[]{"1", "2", "3"});
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsAsSet() {
        DeleteTagsOptions options = new DeleteTagsOptions().resourceIds((Set)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsAsSetStatic() {
        DeleteTagsOptions options = DeleteTagsOptions.Builder.resourceIds((Set)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceType() {
        DeleteTagsOptions options = new DeleteTagsOptions().resourceType(Tag.ResourceType.TEMPLATE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeStatic() {
        DeleteTagsOptions options = DeleteTagsOptions.Builder.resourceType((Tag.ResourceType)Tag.ResourceType.TEMPLATE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeAsString() {
        DeleteTagsOptions options = new DeleteTagsOptions().resourceType("Template");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeAsStringStatic() {
        DeleteTagsOptions options = DeleteTagsOptions.Builder.resourceType((String)"Template");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testTags() {
        DeleteTagsOptions options = new DeleteTagsOptions().tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }

    public void testTagsStatic() {
        DeleteTagsOptions options = DeleteTagsOptions.Builder.tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }
}

