/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.cloudstack.domain.ResourceLimit;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class ResourceLimitToQueryParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof ResourceLimit), (Object)"this binder is only valid for ResourceLimit");
        ResourceLimit limit = (ResourceLimit)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"resourcetype", (Object)("" + limit.getResourceType().getCode()));
        builder.put((Object)"account", (Object)limit.getAccount());
        builder.put((Object)"domainid", (Object)limit.getDomainId());
        builder.put((Object)"max", (Object)("" + limit.getMax()));
        return (R)request.toBuilder().replaceQueryParams((Multimap)builder.build()).build();
    }
}

