/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class AssignVirtualMachineOptions
extends AccountInDomainOptions {
    public static final AssignVirtualMachineOptions NONE = new AssignVirtualMachineOptions();

    public AssignVirtualMachineOptions networkId(String networkId) {
        this.queryParameters.replaceValues((Object)"networkids", (Iterable)ImmutableSet.of((Object)networkId));
        return this;
    }

    public AssignVirtualMachineOptions networkIds(Iterable<String> networkIds) {
        this.queryParameters.replaceValues((Object)"networkids", (Iterable)ImmutableSet.of((Object)Joiner.on((char)',').join(networkIds)));
        return this;
    }

    public Iterable<String> getNetworkIds() {
        if (this.queryParameters.get((Object)"networkids").size() == 1) {
            return Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)Iterables.getOnlyElement((Iterable)this.queryParameters.get((Object)"networkids"))), (Function)new Function<String, String>(){

                public String apply(String arg0) {
                    return arg0;
                }
            });
        }
        return ImmutableSet.of();
    }

    public AssignVirtualMachineOptions securityGroupId(String securityGroupId) {
        this.queryParameters.replaceValues((Object)"securitygroupids", (Iterable)ImmutableSet.of((Object)securityGroupId));
        return this;
    }

    public AssignVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.queryParameters.replaceValues((Object)"securitygroupids", (Iterable)ImmutableSet.of((Object)Joiner.on((char)',').join(securityGroupIds)));
        return this;
    }

    @Override
    public AssignVirtualMachineOptions accountInDomain(String account, String domain) {
        return (AssignVirtualMachineOptions)((Object)AssignVirtualMachineOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public AssignVirtualMachineOptions domainId(String domainId) {
        return (AssignVirtualMachineOptions)((Object)AssignVirtualMachineOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static AssignVirtualMachineOptions networkId(String id) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.networkId(id);
        }

        public static AssignVirtualMachineOptions networkIds(Iterable<String> networkIds) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.networkIds(networkIds);
        }

        public static AssignVirtualMachineOptions securityGroupId(String id) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.securityGroupId(id);
        }

        public static AssignVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static AssignVirtualMachineOptions accountInDomain(String account, String domain) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.accountInDomain(account, domain);
        }

        public static AssignVirtualMachineOptions domainId(String domainId) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.domainId(domainId);
        }
    }
}

