/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListTagsOptions
extends AccountInDomainOptions {
    public static final ListTagsOptions NONE = new ListTagsOptions();

    public ListTagsOptions customer(String customer) {
        this.queryParameters.replaceValues((Object)"customer", (Iterable)ImmutableSet.of((Object)customer));
        return this;
    }

    public ListTagsOptions isRecursive(boolean isRecursive) {
        this.queryParameters.replaceValues((Object)"isrecursive", (Iterable)ImmutableSet.of((Object)("" + isRecursive)));
        return this;
    }

    public ListTagsOptions key(String key) {
        this.queryParameters.replaceValues((Object)"key", (Iterable)ImmutableSet.of((Object)key));
        return this;
    }

    public ListTagsOptions keyword(String keyword) {
        this.queryParameters.replaceValues((Object)"keyword", (Iterable)ImmutableSet.of((Object)keyword));
        return this;
    }

    public ListTagsOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)projectId));
        return this;
    }

    public ListTagsOptions resourceId(String resourceId) {
        this.queryParameters.replaceValues((Object)"resourceid", (Iterable)ImmutableSet.of((Object)resourceId));
        return this;
    }

    public ListTagsOptions resourceType(String resourceType) {
        this.queryParameters.replaceValues((Object)"resourcetype", (Iterable)ImmutableSet.of((Object)resourceType));
        return this;
    }

    public ListTagsOptions resourceType(Tag.ResourceType resourceType) {
        this.queryParameters.replaceValues((Object)"resourcetype", (Iterable)ImmutableSet.of((Object)resourceType.toString()));
        return this;
    }

    public ListTagsOptions value(String value) {
        this.queryParameters.replaceValues((Object)"value", (Iterable)ImmutableSet.of((Object)value));
        return this;
    }

    public ListTagsOptions page(long page) {
        this.queryParameters.replaceValues((Object)"page", (Iterable)ImmutableSet.of((Object)("" + page)));
        return this;
    }

    public ListTagsOptions pageSize(long pageSize) {
        this.queryParameters.replaceValues((Object)"pagesize", (Iterable)ImmutableSet.of((Object)("" + pageSize)));
        return this;
    }

    @Override
    public ListTagsOptions accountInDomain(String account, String domain) {
        return (ListTagsOptions)((Object)ListTagsOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListTagsOptions domainId(String domainId) {
        return (ListTagsOptions)((Object)ListTagsOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static ListTagsOptions accountInDomain(String account, String domain) {
            ListTagsOptions options = new ListTagsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListTagsOptions domainId(String domainId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.domainId(domainId);
        }

        public static ListTagsOptions customer(String customer) {
            ListTagsOptions options = new ListTagsOptions();
            return options.customer(customer);
        }

        public static ListTagsOptions isRecursive(boolean isRecursive) {
            ListTagsOptions options = new ListTagsOptions();
            return options.isRecursive(isRecursive);
        }

        public static ListTagsOptions key(String key) {
            ListTagsOptions options = new ListTagsOptions();
            return options.key(key);
        }

        public static ListTagsOptions keyword(String keyword) {
            ListTagsOptions options = new ListTagsOptions();
            return options.keyword(keyword);
        }

        public static ListTagsOptions projectId(String projectId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.projectId(projectId);
        }

        public static ListTagsOptions resourceId(String resourceId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceId(resourceId);
        }

        public static ListTagsOptions resourceType(String resourceType) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceType(resourceType);
        }

        public static ListTagsOptions resourceType(Tag.ResourceType resourceType) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceType(resourceType);
        }

        public static ListTagsOptions value(String value) {
            ListTagsOptions options = new ListTagsOptions();
            return options.value(value);
        }

        public static ListTagsOptions page(long page) {
            ListTagsOptions options = new ListTagsOptions();
            return options.page(page);
        }

        public static ListTagsOptions pageSize(long pageSize) {
            ListTagsOptions options = new ListTagsOptions();
            return options.pageSize(pageSize);
        }
    }
}

