/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.inject.Module;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.internal.BaseSecurityGroupExtensionLiveTest;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudStackSecurityGroupExtensionLiveTest")
public class CloudStackSecurityGroupExtensionLiveTest
extends BaseSecurityGroupExtensionLiveTest {
    protected Zone zone;

    public CloudStackSecurityGroupExtensionLiveTest() {
        this.provider = "cloudstack";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        CloudStackApi api = (CloudStackApi)((ComputeServiceContext)this.view).unwrapApi(CloudStackApi.class);
        for (Zone z : api.getZoneApi().listZones(new ListZonesOptions[0])) {
            if (!z.isSecurityGroupsEnabled()) continue;
            this.zone = z;
            break;
        }
        if (this.zone == null) {
            this.securityGroupsSupported = false;
        }
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    public Template getNodeTemplate() {
        return ((ComputeServiceContext)this.view).getComputeService().templateBuilder().locationId(this.zone.getId()).build();
    }
}

