/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.features.FirewallApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListEgressFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FirewallApiExpectTest")
public class FirewallApiExpectTest
extends BaseCloudStackExpectTest<FirewallApi> {
    public void testListFirewallRulesWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"9+tdTXe2uYLzAexPNgrMy5Tq8hE="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listfirewallrulesresponse.json"))).build());
        ImmutableSet CIDRs = ImmutableSet.of((Object)"0.0.0.0/0");
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of((Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("2016").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("10").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("8").ipAddress("10.27.27.57").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).tags(new Tag[]{Tag.builder().account("1").domain("ROOT").domainId("1").key("some-tag").resourceId("10").resourceType(Tag.ResourceType.FIREWALL_RULE).value("some-value").build()}).build()));
    }

    public void testListFirewallRulesWhenReponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"9+tdTXe2uYLzAexPNgrMy5Tq8hE="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetFirewallRuleWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"2017"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"6coh9Qdwla94TN1Dl008WlhzZUY="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getfirewallrulesresponse.json"))).build());
        Assert.assertEquals((Object)client.getFirewallRule("2017"), (Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)ImmutableSet.of((Object)"0.0.0.0/0")).build());
    }

    public void testGetFirewallRuleWhenResponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"4"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"rYd8gr7ptdSZlIehBEMQEKsm07Q="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getFirewallRule("4"));
    }

    public void testCreateFirewallRuleForIpAndProtocol() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createFirewallRule"}).addQueryParam("ipaddressid", new String[]{"2"}).addQueryParam("protocol", new String[]{"TCP"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"d0MZ/yhQPAaV+YQmfZsQtQL2C28="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createfirewallrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createFirewallRuleForIpAndProtocol("2", FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[0]);
        Assert.assertEquals((String)response.getJobId(), (String)"2036");
        Assert.assertEquals((String)response.getId(), (String)"2017");
    }

    public void testDeleteFirewallRule() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deleteFirewallRule"}).addQueryParam("id", new String[]{"2015"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"/T5FAO2yGPctaPmg7TEtIEFW3EU="}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletefirewallrulesresponse.json"))).build());
        client.deleteFirewallRule("2015");
    }

    public void testListPortForwardingRulesWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listPortForwardingRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"8SXGJZWdcJfVz4V90Pyod12x9dM="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listportforwardingrulesresponse.json"))).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of((Object)PortForwardingRule.builder().id("18").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(22).virtualMachineId("89").virtualMachineName("i-3-89-VM").IPAddressId("34").IPAddress("72.52.126.63").state(PortForwardingRule.State.ACTIVE).build(), (Object)PortForwardingRule.builder().id("15").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId("3").virtualMachineName("i-3-3-VM").IPAddressId("3").IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).tags(new Tag[]{Tag.builder().account("1").domain("ROOT").domainId("1").key("some-tag").resourceId("15").resourceType(Tag.ResourceType.PORT_FORWARDING_RULE).value("some-value").build()}).build()));
    }

    public void testListPortForwardingRulesWhenReponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listPortForwardingRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"8SXGJZWdcJfVz4V90Pyod12x9dM="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetPortForwardingRuleWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listPortForwardingRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"15"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"JL63p6cJzbb9vaffeV4u60IGlWE="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getportforwardingrulesresponse.json"))).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Object)client.getPortForwardingRule("15"), (Object)PortForwardingRule.builder().id("15").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId("3").virtualMachineName("i-3-3-VM").IPAddressId("3").IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).tags(new Tag[]{Tag.builder().account("1").domain("ROOT").domainId("1").key("some-tag").resourceId("15").resourceType(Tag.ResourceType.PORT_FORWARDING_RULE).value("some-value").build()}).build());
    }

    public void testGetPortForwardingRuleWhenResponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listPortForwardingRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"4"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"4blbBVn2+ZfF8HwoglbmtYoDAjs="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getPortForwardingRule("4"));
    }

    public void testCreatePortForwardingRuleForVirtualMachine() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createPortForwardingRule"}).addQueryParam("ipaddressid", new String[]{"2"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("publicport", new String[]{"22"}).addQueryParam("virtualmachineid", new String[]{"1234"}).addQueryParam("privateport", new String[]{"22"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"84dtGzQp0G6k3z3Gkc3F/HBNS2Y="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createportforwardingrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createPortForwardingRuleForVirtualMachine("2", PortForwardingRule.Protocol.TCP, 22, "1234", 22);
        Assert.assertEquals((String)response.getJobId(), (String)"2035");
        Assert.assertEquals((String)response.getId(), (String)"2015");
    }

    public void testDeletePortForwardingRule() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deletePortForwardingRule"}).addQueryParam("id", new String[]{"2015"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"2UE7KB3wm5ocmR+GMNFKPKfiDo8="}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deleteportforwardingrulesresponse.json"))).build());
        client.deletePortForwardingRule("2015");
    }

    public void testListEgressFirewallRulesWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listEgressFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"j3OpRXs7mEwVKs9KIb4ncRKVO9A="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listegressfirewallrulesresponse.json"))).build());
        ImmutableSet CIDRs = ImmutableSet.of((Object)"0.0.0.0/0");
        Assert.assertEquals((Set)client.listEgressFirewallRules(new ListEgressFirewallRulesOptions[0]), (Set)ImmutableSet.of((Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("2016").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("10").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("8").ipAddress("10.27.27.57").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).tags(new Tag[]{Tag.builder().account("1").domain("ROOT").domainId("1").key("some-tag").resourceId("10").resourceType(Tag.ResourceType.FIREWALL_RULE).value("some-value").build()}).build()));
    }

    public void testListEgressFirewallRulesWhenReponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listEgressFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"j3OpRXs7mEwVKs9KIb4ncRKVO9A="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listEgressFirewallRules(new ListEgressFirewallRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetEgressFirewallRuleWhenResponseIs2xx() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listEgressFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"2017"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"Hi1K5VA3yd3mk0AmgJ2F6y+VzMo="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getegressfirewallrulesresponse.json"))).build());
        Assert.assertEquals((Object)client.getEgressFirewallRule("2017"), (Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)ImmutableSet.of((Object)"0.0.0.0/0")).build());
    }

    public void testGetEgressFirewallRuleWhenResponseIs404() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listEgressFirewallRules"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"4"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"dzb5azKxXZsuGrNRJbRHfna7FMo="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getEgressFirewallRule("4"));
    }

    public void testCreateEgressFirewallRuleForNetworkAndProtocol() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createEgressFirewallRule"}).addQueryParam("networkid", new String[]{"2"}).addQueryParam("protocol", new String[]{"TCP"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"I/OJEqiLp8ZHlZskKUiT5uTRE3M="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createegressfirewallrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createEgressFirewallRuleForNetworkAndProtocol("2", FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[0]);
        Assert.assertEquals((String)response.getJobId(), (String)"2036");
        Assert.assertEquals((String)response.getId(), (String)"2017");
    }

    public void testDeleteEgressFirewallRule() {
        FirewallApi client = (FirewallApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deleteEgressFirewallRule"}).addQueryParam("id", new String[]{"2015"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"S119WNmamKwc5d9qvvkIJznXytg="}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deleteegressfirewallrulesresponse.json"))).build());
        client.deleteEgressFirewallRule("2015");
    }

    @Override
    protected FirewallApi clientFrom(CloudStackContext context) {
        return context.getApi().getFirewallApi();
    }
}

