/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.Capacity;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListCapacityOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalCapacityApiLiveTest")
public class GlobalCapacityApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListCapacity() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set response = this.globalAdminClient.getCapacityClient().listCapacity(new ListCapacityOptions[0]);
        Assert.assertNotNull((Object)response);
        Assert.assertNotEquals((Object)0, (Object)response.size());
        int count = 0;
        for (Capacity capacity : response) {
            Assert.assertTrue((capacity.getCapacityTotal() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((capacity.getCapacityUsed() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((capacity.getPercentUsed() >= 0.0 ? 1 : 0) != 0);
            Assert.assertNotEquals((Object)Capacity.Type.UNRECOGNIZED, (Object)capacity.getType());
            Assert.assertNotNull((Object)capacity.getZoneName());
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0, (String)"No capacities were returned, so I couldn't test");
    }
}

