/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GuestOSApiLiveTest")
public class GuestOSApiLiveTest
extends BaseCloudStackApiLiveTest {
    public void testListOSTypes() throws Exception {
        Set response = this.client.getGuestOSApi().listOSTypes(new ListOSTypesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (OSType type : response) {
            OSType newDetails = (OSType)Iterables.getOnlyElement((Iterable)this.client.getGuestOSApi().listOSTypes(new ListOSTypesOptions[]{ListOSTypesOptions.Builder.id((String)type.getId())}));
            Assert.assertEquals((String)type.getId(), (String)newDetails.getId());
            this.checkOSType(type);
        }
    }

    public void testListOSCategories() throws Exception {
        Map response = this.client.getGuestOSApi().listOSCategories();
        assert (null != response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry<String, String> entry : response.entrySet()) {
            this.checkOSCategory(entry);
        }
    }

    protected void checkOSCategory(Map.Entry<String, String> category) {
        Assert.assertEquals(category, (Object)this.client.getGuestOSApi().getOSCategory(category.getKey()));
        assert (category.getKey() != null) : category;
        assert (category.getValue() != null) : category;
    }

    protected void checkOSType(OSType type) {
        Assert.assertEquals((String)type.getId(), (String)this.client.getGuestOSApi().getOSType(type.getId()).getId());
        assert (type.getId() != null) : type;
        assert (type.getOSCategoryId() != null) : type;
        assert (type.getDescription() != null) : type;
    }
}

