/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.predicates.NetworkOfferingPredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NetworkApiLiveTest")
public class NetworkApiLiveTest
extends BaseCloudStackApiLiveTest {
    private boolean networksSupported;
    private Zone zone;

    @Override
    @BeforeGroups(groups={"live"})
    public void setupContext() {
        super.setupContext();
        try {
            this.zone = (Zone)Iterables.find((Iterable)this.client.getZoneApi().listZones(new ListZonesOptions[0]), (Predicate)ZonePredicates.supportsAdvancedNetworks());
            this.networksSupported = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateGuestVirtualNetwork() {
        NetworkOffering offering;
        if (!this.networksSupported) {
            return;
        }
        try {
            offering = (NetworkOffering)Iterables.find((Iterable)this.client.getOfferingApi().listNetworkOfferings(new ListNetworkOfferingsOptions[0]), (Predicate)NetworkOfferingPredicates.supportsGuestVirtualNetworks());
        }
        catch (NoSuchElementException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "guest networks not supported, skipping test");
            return;
        }
        String name = this.prefix + "-virtual";
        Network network = null;
        try {
            network = this.client.getNetworkApi().createNetworkInZone(this.zone.getId(), offering.getId(), name, name, new CreateNetworkOptions[0]);
            this.checkNetwork(network);
        }
        catch (IllegalStateException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "couldn't create a network, skipping test", e);
        }
        finally {
            String jobId;
            if (network != null && (jobId = this.client.getNetworkApi().deleteNetwork(network.getId())) != null) {
                this.jobComplete.apply((Object)jobId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateVLANNetwork() {
        NetworkOffering offering;
        this.skipIfNotDomainAdmin();
        if (!this.networksSupported) {
            return;
        }
        try {
            offering = (NetworkOffering)Iterables.get((Iterable)this.cloudStackContext.getApi().getOfferingApi().listNetworkOfferings(new ListNetworkOfferingsOptions[]{ListNetworkOfferingsOptions.Builder.specifyVLAN((boolean)true).zoneId(this.zone.getId())}), (int)0);
        }
        catch (NoSuchElementException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "VLAN networks not supported, skipping test");
            return;
        }
        String name = this.prefix + "-vlan";
        Network network = null;
        try {
            network = this.domainAdminClient.getNetworkApi().createNetworkInZone(this.zone.getId(), offering.getId(), name, name, new CreateNetworkOptions[]{CreateNetworkOptions.Builder.vlan((String)"65").startIP("192.168.1.2").netmask("255.255.255.0").gateway("192.168.1.1")});
            this.checkNetwork(network);
        }
        catch (IllegalStateException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "couldn't create a network, skipping test", e);
        }
        finally {
            String jobId;
            if (network != null && (jobId = this.adminClient.getNetworkApi().deleteNetwork(network.getId())) != null) {
                this.adminJobComplete.apply((Object)jobId);
            }
        }
    }

    @Test
    public void testListNetworks() throws Exception {
        if (!this.networksSupported) {
            return;
        }
        Set response = this.client.getNetworkApi().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.accountInDomain((String)this.user.getAccount(), (String)this.user.getDomainId())});
        assert (null != response);
        long networkCount = response.size();
        Assert.assertTrue((networkCount >= 0L ? 1 : 0) != 0);
        for (Network network : response) {
            Network newDetails = (Network)Iterables.getOnlyElement((Iterable)this.client.getNetworkApi().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.id((String)network.getId())}));
            Assert.assertEquals((Object)network, (Object)newDetails);
            Assert.assertEquals((Object)network, (Object)this.client.getNetworkApi().getNetwork(network.getId()));
            this.checkNetwork(network);
        }
    }

    private void checkNetwork(Network network) {
        assert (network.getId() != null) : network;
        assert (network.getName() != null) : network;
        assert (network.getDNS().size() != 0) : network;
        assert (network.getGuestIPType() != null && network.getGuestIPType() != GuestIPType.UNRECOGNIZED) : network;
        assert (network.getBroadcastDomainType() != null) : network;
        assert (network.getDisplayText() != null) : network;
        assert (network.getNetworkOfferingAvailability() != null) : network;
        assert (network.getNetworkOfferingDisplayText() != null) : network;
        assert (network.getNetworkOfferingId() != null) : network;
        assert (network.getNetworkOfferingName() != null) : network;
        assert (network.getRelated() != null) : network;
        assert (network.getServices().size() != 0) : network;
        assert (network.getState() != null) : network;
        assert (network.getTrafficType() != null) : network;
        assert (network.getZoneId() != null) : network;
        assert (network.getDomain() != null) : network;
        switch (network.getGuestIPType()) {
            case VIRTUAL: {
                assert (network.getNetmask() == null) : network;
                assert (network.getGateway() == null) : network;
                assert (network.getVLAN() == null) : network;
                assert (network.getStartIP() == null) : network;
                assert (network.getEndIP() == null) : network;
                break;
            }
            case DIRECT: {
                assert (network.getNetmask() != null) : network;
                assert (network.getGateway() != null) : network;
                assert (network.getVLAN() != null) : network;
                Assert.assertEquals((Object)network.getBroadcastURI(), (Object)URI.create("vlan://" + network.getVLAN()));
                assert (network.getStartIP() != null) : network;
                assert (network.getEndIP() != null) : network;
                break;
            }
        }
    }
}

