/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Resource;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.jclouds.cloudstack.options.DeleteTagsOptions;
import org.jclouds.cloudstack.options.ListDiskOfferingsOptions;
import org.jclouds.cloudstack.options.ListTagsOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.logging.Logger;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="TagApiLiveTest")
public class TagApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Resource
    Logger logger = Logger.NULL;
    protected String prefix = System.getProperty("user.name") + "-" + ((Object)((Object)this)).getClass().getSimpleName();
    protected String volumeToDelete;
    private String zoneId;

    @BeforeMethod(groups={"live"})
    public void setZoneId() {
        Set zones = this.client.getZoneApi().listZones(new ListZonesOptions[0]);
        AssertJUnit.assertNotNull((Object)zones);
        AssertJUnit.assertFalse((boolean)zones.isEmpty());
        this.zoneId = ((Zone)Iterables.get((Iterable)zones, (int)0)).getId();
    }

    public void testCreateTags() {
        this.createVolumeToTag();
        AsyncCreateResponse job = this.client.getTagApi().createTags(CreateTagsOptions.Builder.resourceType((String)"Volume").resourceIds(new String[]{this.volumeToDelete}).tags((Map)ImmutableMap.of((Object)(this.prefix + "-first-tag"), (Object)"first-tag-value", (Object)(this.prefix + "-second-tag"), (Object)"second-tag-value")));
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
    }

    @Test(dependsOnMethods={"testCreateTags"})
    public void testListTags() {
        Set tags = this.client.getTagApi().listTags(new ListTagsOptions[0]);
        AssertJUnit.assertNotNull((Object)tags);
        AssertJUnit.assertFalse((boolean)tags.isEmpty());
        for (Tag tag : tags) {
            TagApiLiveTest.checkTag(tag);
        }
    }

    @Test(dependsOnMethods={"testListTags"})
    public void testListSingleTag() {
        Set tags = this.client.getTagApi().listTags(new ListTagsOptions[]{ListTagsOptions.Builder.key((String)(this.prefix + "-second-tag"))});
        AssertJUnit.assertNotNull((Object)tags);
        AssertJUnit.assertFalse((boolean)tags.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)tags.size());
        for (Tag tag : tags) {
            AssertJUnit.assertEquals((String)this.volumeToDelete, (String)tag.getResourceId());
            TagApiLiveTest.checkTag(tag);
        }
    }

    @Test(dependsOnMethods={"testListSingleTag"})
    public void testListResourceByTag() {
        Set volumes = this.client.getVolumeApi().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.tags((Map)ImmutableMap.of((Object)(this.prefix + "-second-tag"), (Object)"second-tag-value"))});
        AssertJUnit.assertNotNull((Object)volumes);
        AssertJUnit.assertFalse((boolean)volumes.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)volumes.size());
    }

    @Test(dependsOnMethods={"testListResourceByTag"})
    public void testDeleteTags() {
        AsyncCreateResponse job = this.client.getTagApi().deleteTags(DeleteTagsOptions.Builder.resourceType((String)"Volume").resourceIds(new String[]{this.volumeToDelete}).tags((Map)ImmutableMap.of((Object)(this.prefix + "-first-tag"), (Object)"first-tag-value", (Object)(this.prefix + "-second-tag"), (Object)"second-tag-value")));
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
    }

    static void checkTag(Tag tag) {
        AssertJUnit.assertNotNull((Object)tag.getAccount());
        AssertJUnit.assertNotNull((Object)tag.getResourceId());
    }

    protected DiskOffering getPreferredDiskOffering() {
        for (DiskOffering candidate : this.client.getOfferingApi().listDiskOfferings(new ListDiskOfferingsOptions[0])) {
            if (candidate.isCustomized()) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable DiskOffering found.");
    }

    protected void createVolumeToTag() {
        AsyncCreateResponse job = this.client.getVolumeApi().createVolumeFromDiskOfferingInZone(this.prefix + "-jclouds-volume", this.getPreferredDiskOffering().getId(), this.zoneId);
        AssertJUnit.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.logger.info("created volume " + job.getId(), new Object[0]);
        this.volumeToDelete = job.getId();
    }

    @AfterClass(groups={"live"})
    protected void tearDownContext() {
        try {
            this.client.getVolumeApi().deleteVolume(this.volumeToDelete);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDownContext();
    }
}

