/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.ZoneApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneApiExpectTest")
public class ZoneApiExpectTest
extends BaseCloudStackExpectTest<ZoneApi> {
    public void testListZonesWhenResponseIs2xx() {
        ZoneApi client = (ZoneApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listZones"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"8iHCtck0qfxFTqJ8reyAObRf31I="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listzonesresponse.json"))).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of((Object)Zone.builder().id("1").name("San Jose 1").networkType(NetworkType.ADVANCED).securityGroupsEnabled(false).build(), (Object)Zone.builder().id("2").name("Chicago").networkType(NetworkType.ADVANCED).securityGroupsEnabled(true).tags(new Tag[]{Tag.builder().account("1").domain("ROOT").domainId("1").key("some-tag").resourceId("2").resourceType(Tag.ResourceType.ZONE).value("some-value").build()}).build()));
    }

    public void testListZonesWhenResponseIs404() {
        ZoneApi client = (ZoneApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listZones"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"8iHCtck0qfxFTqJ8reyAObRf31I="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of());
    }

    @Override
    protected ZoneApi clientFrom(CloudStackContext context) {
        return context.getApi().getZoneApi();
    }
}

