/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.features.GuestOSApi;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.predicates.OSCategoryIn;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class OSCategoryInTest {
    private CloudStackApi client;
    private GuestOSApi guestOSClient;
    private Set<String> acceptableCategories = ImmutableSet.of((Object)"Ubuntu");

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        this.guestOSClient = (GuestOSApi)EasyMock.createMock(GuestOSApi.class);
        EasyMock.expect((Object)this.client.getGuestOSApi()).andReturn((Object)this.guestOSClient).times(2);
        HashMap osCategories = Maps.newHashMap();
        osCategories.put("1", "Ubuntu");
        osCategories.put("2", "CentOS");
        osCategories.put("3", "RHEL");
        EasyMock.expect((Object)this.guestOSClient.listOSCategories()).andReturn((Object)osCategories);
        ImmutableSet osTypes = ImmutableSet.of((Object)OSType.builder().id("10").OSCategoryId("1").description("Ubuntu 10.04 LTS").build(), (Object)OSType.builder().id("20").OSCategoryId("2").description("CentOS 5.4").build(), (Object)OSType.builder().id("30").OSCategoryId("3").description("RHEL 6").build());
        EasyMock.expect((Object)this.guestOSClient.listOSTypes(new ListOSTypesOptions[0])).andReturn((Object)osTypes);
        EasyMock.replay((Object[])new Object[]{this.client, this.guestOSClient});
    }

    @Test
    public void testTemplateInAcceptableCategory() {
        Assert.assertTrue((boolean)new OSCategoryIn(this.client).apply(this.acceptableCategories).apply((Object)Template.builder().id("1").OSTypeId("10").build()));
        EasyMock.verify((Object[])new Object[]{this.client, this.guestOSClient});
    }

    @Test
    public void testTemplateNotInAcceptableCategory() {
        Assert.assertFalse((boolean)new OSCategoryIn(this.client).apply(this.acceptableCategories).apply((Object)Template.builder().id("2").OSTypeId("30").build()));
        EasyMock.verify((Object[])new Object[]{this.client, this.guestOSClient});
    }
}

