/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface DomainDomainApi {
    @Named(value="listDomains")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomains", "true"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Domain> listDomains(ListDomainsOptions ... var1);

    @Named(value="listDomains")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomains", "true"})
    @SelectJson(value={"domain"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Domain getDomainById(@QueryParam(value="id") String var1);

    @Named(value="listDomainChildren")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomainChildren", "true"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Domain> listDomainChildren(ListDomainChildrenOptions ... var1);
}

