/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListEgressFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface FirewallApi {
    @Named(value="listFirewallRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listFirewallRules", "true"})
    @SelectJson(value={"firewallrule"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<FirewallRule> listFirewallRules(ListFirewallRulesOptions ... var1);

    @Named(value="listFirewallRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listFirewallRules", "true"})
    @SelectJson(value={"firewallrule"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public FirewallRule getFirewallRule(@QueryParam(value="id") String var1);

    @Named(value="createFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"createFirewallRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createFirewallRuleForIpAndProtocol(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") FirewallRule.Protocol var2, CreateFirewallRuleOptions ... var3);

    @Named(value="createFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"createFirewallRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createFirewallRuleForIpProtocolAndPort(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") FirewallRule.Protocol var2, @QueryParam(value="startPort") int var3, @QueryParam(value="endPort") int var4);

    @Named(value="deleteFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"deleteFirewallRule"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteFirewallRule(@QueryParam(value="id") String var1);

    @Named(value="listEgressFirewallRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listEgressFirewallRules", "true"})
    @SelectJson(value={"firewallrule"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<FirewallRule> listEgressFirewallRules(ListEgressFirewallRulesOptions ... var1);

    @Named(value="listEgressFirewallRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listEgressFirewallRules", "true"})
    @SelectJson(value={"firewallrule"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public FirewallRule getEgressFirewallRule(@QueryParam(value="id") String var1);

    @Named(value="createEgressFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"createEgressFirewallRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createEgressFirewallRuleForNetworkAndProtocol(@QueryParam(value="networkid") String var1, @QueryParam(value="protocol") FirewallRule.Protocol var2, CreateFirewallRuleOptions ... var3);

    @Named(value="createEgressFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"createEgressFirewallRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createEgressFirewallRuleForNetworkProtocolAndPort(@QueryParam(value="networkId") String var1, @QueryParam(value="protocol") FirewallRule.Protocol var2, @QueryParam(value="startPort") int var3, @QueryParam(value="endPort") int var4);

    @Named(value="deleteEgressFirewallRule")
    @GET
    @QueryParams(keys={"command"}, values={"deleteEgressFirewallRule"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteEgressFirewallRule(@QueryParam(value="id") String var1);

    @Named(value="listPortForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPortForwardingRules", "true"})
    @SelectJson(value={"portforwardingrule"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<PortForwardingRule> listPortForwardingRules(ListPortForwardingRulesOptions ... var1);

    @Named(value="listPortForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPortForwardingRules", "true"})
    @SelectJson(value={"portforwardingrule"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public PortForwardingRule getPortForwardingRule(@QueryParam(value="id") String var1);

    @Named(value="createPortForwardingRule")
    @GET
    @QueryParams(keys={"command"}, values={"createPortForwardingRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createPortForwardingRuleForVirtualMachine(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") PortForwardingRule.Protocol var2, @QueryParam(value="publicport") int var3, @QueryParam(value="virtualmachineid") String var4, @QueryParam(value="privateport") int var5);

    @Named(value="deletePortForwardingRule")
    @GET
    @QueryParams(keys={"command"}, values={"deletePortForwardingRule"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deletePortForwardingRule(@QueryParam(value="id") String var1);
}

