/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.binders.BindTemplateMetadataToQueryParams;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.domain.TemplatePermission;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ExtractTemplateOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.RegisterTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplatePermissionsOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface TemplateApi {
    @Named(value="createTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"createTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createTemplate(@BinderParam(value=BindTemplateMetadataToQueryParams.class) TemplateMetadata var1, CreateTemplateOptions ... var2);

    @Named(value="registerTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"registerTemplate"})
    @SelectJson(value={"template"})
    @Consumes(value={"application/json"})
    public Set<Template> registerTemplate(@BinderParam(value=BindTemplateMetadataToQueryParams.class) TemplateMetadata var1, @QueryParam(value="format") String var2, @QueryParam(value="hypervisor") String var3, @QueryParam(value="url") String var4, @QueryParam(value="zoneid") String var5, RegisterTemplateOptions ... var6);

    @Named(value="updateTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"updateTemplate"})
    @SelectJson(value={"template"})
    @Consumes(value={"application/json"})
    public Template updateTemplate(@QueryParam(value="id") String var1, UpdateTemplateOptions ... var2);

    @Named(value="copyTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"copyTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse copyTemplateToZone(@QueryParam(value="id") String var1, @QueryParam(value="sourcezoneid") String var2, @QueryParam(value="destzoneid") String var3);

    @Named(value="deleteTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"deleteTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse deleteTemplate(@QueryParam(value="id") String var1, DeleteTemplateOptions ... var2);

    @Named(value="listTemplates")
    @GET
    @QueryParams(keys={"command", "listAll", "templatefilter"}, values={"listTemplates", "true", "executable"})
    @SelectJson(value={"template"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Template> listTemplates();

    @Named(value="listTemplates")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listTemplates", "true"})
    @SelectJson(value={"template"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Template> listTemplates(ListTemplatesOptions var1);

    @Named(value="listTemplates")
    @GET
    @QueryParams(keys={"command", "listAll", "templatefilter"}, values={"listTemplates", "true", "executable"})
    @SelectJson(value={"template"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Template getTemplateInZone(@QueryParam(value="id") String var1, @QueryParam(value="zoneid") String var2);

    @Named(value="updateTemplatePermissions")
    @GET
    @QueryParams(keys={"command"}, values={"updateTemplatePermissions"})
    public void updateTemplatePermissions(@QueryParam(value="id") String var1, UpdateTemplatePermissionsOptions ... var2);

    @Named(value="listTemplatePermissions")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listTemplatePermissions", "true"})
    @Unwrap
    @Consumes(value={"application/json"})
    public Set<TemplatePermission> listTemplatePermissions(@QueryParam(value="id") String var1, AccountInDomainOptions ... var2);

    @Named(value="extractTemplate")
    @GET
    @QueryParams(keys={"command"}, values={"extractTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse extractTemplate(@QueryParam(value="id") String var1, @QueryParam(value="mode") ExtractMode var2, @QueryParam(value="zoneid") String var3, ExtractTemplateOptions ... var4);
}

