/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface ZoneApi {
    @Named(value="listZones")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listZones", "true"})
    @SelectJson(value={"zone"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Zone> listZones(ListZonesOptions ... var1);

    @Named(value="listZones")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listZones", "true"})
    @SelectJson(value={"zone"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Zone getZone(@QueryParam(value="id") String var1);
}

