/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.annotation.PreDestroy;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionApi;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;

@Singleton
public class InvalidateSessionAndRetryOn401AndLogoutOnClose
extends BackoffLimitedRetryHandler {
    private final LoadingCache<Credentials, LoginResponse> authenticationResponseCache;
    private final SessionApi sessionClient;

    @Inject
    protected InvalidateSessionAndRetryOn401AndLogoutOnClose(LoadingCache<Credentials, LoginResponse> authenticationResponseCache, SessionApi sessionClient) {
        this.authenticationResponseCache = authenticationResponseCache;
        this.sessionClient = sessionClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        try {
            switch (response.getStatusCode()) {
                case 401: {
                    this.authenticationResponseCache.invalidateAll();
                    boolean bl = super.shouldRetryRequest(command, response);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }

    @PreDestroy
    public void logoutOnClose() {
        for (LoginResponse s : this.authenticationResponseCache.asMap().values()) {
            try {
                this.sessionClient.logoutUser(s.getSessionKey());
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "error logging out session %s", new Object[]{s.getSessionKey()});
            }
        }
    }
}

