/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudstack.domain.Zone;

public class ZoneIdToZoneSupplier
implements Supplier<LoadingCache<String, Zone>> {
    private final LoadingCache<String, Zone> cache;

    @Inject
    public ZoneIdToZoneSupplier(CacheLoader<String, Zone> zoneIdToZone, @Named(value="jclouds.session-interval") long expirationSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expirationSecs, TimeUnit.SECONDS).build(zoneIdToZone);
    }

    public LoadingCache<String, Zone> get() {
        return this.cache;
    }
}

