/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ClassnameFilter
implements Filter {
    private static final String DEFAULT_LEVEL_PROP = "com.github.fommil.logging.ClassnameFilter.level";

    public boolean isLoggable(LogRecord record) {
        String source;
        LogManager manager = LogManager.getLogManager();
        Level allowed = this.getLevel(manager, source = record.getSourceClassName());
        if (allowed == Level.OFF) {
            return false;
        }
        return allowed.intValue() <= record.getLevel().intValue();
    }

    Level getLevel(LogManager manager, String fqn) {
        if (fqn == null || fqn.isEmpty()) {
            String level = manager.getProperty(DEFAULT_LEVEL_PROP);
            if (level != null) {
                return Level.parse(level);
            }
            return Level.ALL;
        }
        String level = manager.getProperty(fqn + ".level");
        if (level != null) {
            return Level.parse(level);
        }
        int dollar = fqn.lastIndexOf("$");
        if (dollar > 0) {
            return this.getLevel(manager, fqn.substring(0, dollar));
        }
        int dot = fqn.lastIndexOf(".");
        if (dot <= 0) {
            return this.getLevel(manager, "");
        }
        return this.getLevel(manager, fqn.substring(0, dot));
    }
}

