/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.logging;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class CustomFormatter
extends Formatter {
    private static final String DEFAULT_FORMAT = "%L: %m [%c.%M %t]";
    private static final String[] DEFAULT_EXCLUDE = new String[0];
    private final MessageFormat messageFormat;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final String[] excluded;

    public CustomFormatter() {
        String propName = this.getClass().getName() + ".format";
        String format = LogManager.getLogManager().getProperty(propName);
        this.messageFormat = this.readFormat(format);
        String excludePropName = this.getClass().getName() + ".stackExclude";
        String excludeProperty = LogManager.getLogManager().getProperty(excludePropName);
        this.excluded = this.readExclude(excludeProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord record) {
        Throwable thrown;
        String[] arguments = new String[11];
        arguments[0] = record.getLevel().toString();
        arguments[1] = record.getMessage();
        if ((arguments[1] == null || arguments[1].length() == 0) && (thrown = record.getThrown()) != null) {
            arguments[1] = thrown.getMessage();
        }
        arguments[2] = record.getSourceMethodName() != null ? record.getSourceMethodName() : "?";
        Date date = new Date(record.getMillis());
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            arguments[3] = this.dateFormat.format(date);
        }
        arguments[4] = record.getSourceClassName() != null ? record.getSourceClassName() : "?";
        arguments[5] = Integer.valueOf(record.getThreadID()).toString();
        arguments[6] = record.getLoggerName();
        int start = arguments[4].lastIndexOf(".") + 1;
        arguments[7] = start > 0 && start < arguments[4].length() ? arguments[4].substring(start) : arguments[4];
        if (record.getThrown() != null) {
            arguments[8] = record.getThrown().getMessage();
            arguments[9] = record.getThrown().getClass().getName();
            arguments[10] = this.filteredStackTrace(record.getThrown());
        } else {
            arguments[8] = "";
            arguments[9] = "";
            arguments[10] = "";
        }
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            return this.messageFormat.format(arguments);
        }
    }

    private MessageFormat readFormat(String format) {
        if (format == null || format.trim().length() == 0) {
            format = DEFAULT_FORMAT;
        }
        if (format.contains("{") || format.contains("}")) {
            throw new IllegalArgumentException("curly braces not allowed");
        }
        format = format.replace("%L", "{0}").replace("%m", "{1}").replace("%M", "{2}").replace("%t", "{3}").replace("%c", "{4}").replace("%T", "{5}").replace("%n", "{6}").replace("%C", "{7}").replace("%e", "{8}").replace("%E", "{9}").replace("%S", "{10}") + "\n";
        return new MessageFormat(format);
    }

    private String[] readExclude(String property) {
        if (property == null || property.trim().length() == 0) {
            return DEFAULT_EXCLUDE;
        }
        String[] pieces = property.split(" ");
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = pieces[i].trim();
        }
        return pieces;
    }

    private String filteredStackTrace(Throwable thrown) {
        StackTraceElement[] trace = thrown.getStackTrace();
        if (trace.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        block0: for (StackTraceElement traceElement : trace) {
            String element = traceElement.toString();
            for (String exclude : this.excluded) {
                if (element.startsWith(exclude)) continue block0;
            }
            builder.append("\n\tat ");
            builder.append(element);
        }
        if (thrown.getCause() != null) {
            builder.append("\n");
            builder.append("CAUSE: ");
            builder.append(thrown.getCause().getClass().getName());
            builder.append(": ");
            builder.append(thrown.getCause().getMessage());
        }
        return builder.toString();
    }
}

