/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.core;

import com.github.geko444.im4java.core.Operation;

public class IMOps
extends Operation {
    protected IMOps() {
    }

    public IMOps adaptiveBlur() {
        this.iCmdArgs.add("-adaptive-blur");
        return this;
    }

    public IMOps adaptiveBlur(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveBlur(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveResize() {
        this.iCmdArgs.add("-adaptive-resize");
        return this;
    }

    public IMOps adaptiveResize(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveResize(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveResize(Integer width, Integer height, Character special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveResize(Integer width, Integer height, String special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveSharpen() {
        this.iCmdArgs.add("-adaptive-sharpen");
        return this;
    }

    public IMOps adaptiveSharpen(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-sharpen");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adaptiveSharpen(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-adaptive-sharpen");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps adjoin() {
        this.iCmdArgs.add("-adjoin");
        return this;
    }

    public IMOps p_adjoin() {
        this.iCmdArgs.add("+adjoin");
        return this;
    }

    public IMOps affine() {
        this.iCmdArgs.add("-affine");
        return this;
    }

    public IMOps affine(Double sx) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps affine(Double sx, Double rx) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (sx != null || rx != null) {
            buf.append(",");
        }
        if (rx != null) {
            buf.append(rx.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps affine(Double sx, Double rx, Double ry) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (sx != null || rx != null) {
            buf.append(",");
        }
        if (rx != null) {
            buf.append(rx.toString());
        }
        if (rx != null || ry != null) {
            buf.append(",");
        }
        if (ry != null) {
            buf.append(ry.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps affine(Double sx, Double rx, Double ry, Double sy) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (sx != null || rx != null) {
            buf.append(",");
        }
        if (rx != null) {
            buf.append(rx.toString());
        }
        if (rx != null || ry != null) {
            buf.append(",");
        }
        if (ry != null) {
            buf.append(ry.toString());
        }
        if (ry != null || sy != null) {
            buf.append(",");
        }
        if (sy != null) {
            buf.append(sy.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (sx != null || rx != null) {
            buf.append(",");
        }
        if (rx != null) {
            buf.append(rx.toString());
        }
        if (rx != null || ry != null) {
            buf.append(",");
        }
        if (ry != null) {
            buf.append(ry.toString());
        }
        if (ry != null || sy != null) {
            buf.append(",");
        }
        if (sy != null) {
            buf.append(sy.toString());
        }
        if (sy != null || tx != null) {
            buf.append(",");
        }
        if (tx != null) {
            buf.append(tx.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx, Double ty) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-affine");
        if (sx != null) {
            buf.append(sx.toString());
        }
        if (sx != null || rx != null) {
            buf.append(",");
        }
        if (rx != null) {
            buf.append(rx.toString());
        }
        if (rx != null || ry != null) {
            buf.append(",");
        }
        if (ry != null) {
            buf.append(ry.toString());
        }
        if (ry != null || sy != null) {
            buf.append(",");
        }
        if (sy != null) {
            buf.append(sy.toString());
        }
        if (sy != null || tx != null) {
            buf.append(",");
        }
        if (tx != null) {
            buf.append(tx.toString());
        }
        if (tx != null || ty != null) {
            buf.append(",");
        }
        if (ty != null) {
            buf.append(ty.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps alpha() {
        this.iCmdArgs.add("-alpha");
        return this;
    }

    public IMOps alpha(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-alpha");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps annotate() {
        this.iCmdArgs.add("-annotate");
        return this;
    }

    public IMOps annotate(Integer xr) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-annotate");
        if (xr != null) {
            buf.append(xr.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps annotate(Integer xr, Integer yr) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-annotate");
        if (xr != null) {
            buf.append(xr.toString());
        }
        if (xr != null || yr != null) {
            buf.append("x");
        }
        if (yr != null) {
            buf.append(yr.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps annotate(Integer xr, Integer yr, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-annotate");
        if (xr != null) {
            buf.append(xr.toString());
        }
        if (xr != null || yr != null) {
            buf.append("x");
        }
        if (yr != null) {
            buf.append(yr.toString());
        }
        if (yr != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps annotate(Integer xr, Integer yr, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-annotate");
        if (xr != null) {
            buf.append(xr.toString());
        }
        if (xr != null || yr != null) {
            buf.append("x");
        }
        if (yr != null) {
            buf.append(yr.toString());
        }
        if (yr != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps annotate(Integer xr, Integer yr, Integer x, Integer y, String text) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-annotate");
        if (xr != null) {
            buf.append(xr.toString());
        }
        if (xr != null || yr != null) {
            buf.append("x");
        }
        if (yr != null) {
            buf.append(yr.toString());
        }
        if (yr != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || text != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps antialias() {
        this.iCmdArgs.add("-antialias");
        return this;
    }

    public IMOps p_antialias() {
        this.iCmdArgs.add("+antialias");
        return this;
    }

    public IMOps append() {
        this.iCmdArgs.add("-append");
        return this;
    }

    public IMOps p_append() {
        this.iCmdArgs.add("+append");
        return this;
    }

    public IMOps attenuate() {
        this.iCmdArgs.add("-attenuate");
        return this;
    }

    public IMOps attenuate(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-attenuate");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps authenticate() {
        this.iCmdArgs.add("-authenticate");
        return this;
    }

    public IMOps authenticate(String password) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-authenticate");
        if (password != null) {
            buf.append(password.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps autoGamma() {
        this.iCmdArgs.add("-auto-gamma");
        return this;
    }

    public IMOps autoLevel() {
        this.iCmdArgs.add("-auto-level");
        return this;
    }

    public IMOps autoOrient() {
        this.iCmdArgs.add("-auto-orient");
        return this;
    }

    public IMOps average() {
        this.iCmdArgs.add("-average");
        return this;
    }

    public IMOps backdrop() {
        this.iCmdArgs.add("-backdrop");
        return this;
    }

    public IMOps backdrop(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-backdrop");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps background() {
        this.iCmdArgs.add("-background");
        return this;
    }

    public IMOps background(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-background");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bench() {
        this.iCmdArgs.add("-bench");
        return this;
    }

    public IMOps bench(Integer iterations) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-bench");
        if (iterations != null) {
            buf.append(iterations.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blend() {
        this.iCmdArgs.add("-blend");
        return this;
    }

    public IMOps blend(Integer srcPercent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blend");
        if (srcPercent != null) {
            buf.append(srcPercent.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blend(Integer srcPercent, Integer dstPercent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blend");
        if (srcPercent != null) {
            buf.append(srcPercent.toString());
        }
        if (srcPercent != null || dstPercent != null) {
            buf.append("x");
        }
        if (dstPercent != null) {
            buf.append(dstPercent.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bias() {
        this.iCmdArgs.add("-bias");
        return this;
    }

    public IMOps bias(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-bias");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bias(Integer value, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-bias");
        if (value != null) {
            buf.append(value.toString());
        }
        if (value != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blackPointCompensation() {
        this.iCmdArgs.add("-black-point-compensation");
        return this;
    }

    public IMOps blackThreshold() {
        this.iCmdArgs.add("-black-threshold");
        return this;
    }

    public IMOps blackThreshold(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-black-threshold");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blackThreshold(Double threshold, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-black-threshold");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (threshold != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bluePrimary() {
        this.iCmdArgs.add("-blue-primary");
        return this;
    }

    public IMOps bluePrimary(Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blue-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bluePrimary(Double x, Double y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blue-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            buf.append(",");
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blueShift() {
        this.iCmdArgs.add("-blue-shift");
        return this;
    }

    public IMOps blueShift(Double factor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blue-shift");
        if (factor != null) {
            buf.append(factor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blur() {
        this.iCmdArgs.add("-blur");
        return this;
    }

    public IMOps blur(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps blur(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps bordercolor() {
        this.iCmdArgs.add("-bordercolor");
        return this;
    }

    public IMOps bordercolor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-bordercolor");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps border() {
        this.iCmdArgs.add("-border");
        return this;
    }

    public IMOps border(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-border");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps border(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-border");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps borderwidth() {
        this.iCmdArgs.add("-borderwidth");
        return this;
    }

    public IMOps borderwidth(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-borderwidth");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps borderwidth(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-borderwidth");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps borderwidth(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-borderwidth");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps borderwidth(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-borderwidth");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps brightnessContrast() {
        this.iCmdArgs.add("-brightness-contrast");
        return this;
    }

    public IMOps brightnessContrast(Double brightness) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-brightness-contrast");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps brightnessContrast(Double brightness, Double contrast) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-brightness-contrast");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (brightness != null || contrast != null) {
            buf.append("x");
        }
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps brightnessContrast(Double brightness, Double contrast, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-brightness-contrast");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (brightness != null || contrast != null) {
            buf.append("x");
        }
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (contrast != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps cache() {
        this.iCmdArgs.add("-cache");
        return this;
    }

    public IMOps cache(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-cache");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps caption() {
        this.iCmdArgs.add("-caption");
        return this;
    }

    public IMOps caption(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-caption");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps cdl() {
        this.iCmdArgs.add("-cdl");
        return this;
    }

    public IMOps cdl(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-cdl");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_channel() {
        this.iCmdArgs.add("+channel");
        return this;
    }

    public IMOps channel() {
        this.iCmdArgs.add("-channel");
        return this;
    }

    public IMOps channel(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-channel");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps charcoal() {
        this.iCmdArgs.add("-charcoal");
        return this;
    }

    public IMOps charcoal(Integer factor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-charcoal");
        if (factor != null) {
            buf.append(factor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps chop() {
        this.iCmdArgs.add("-chop");
        return this;
    }

    public IMOps chop(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-chop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps chop(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-chop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps chop(Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-chop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps chop(Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-chop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps chop(Integer width, Integer height, Integer x, Integer y, Boolean percent) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-chop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps clamp() {
        this.iCmdArgs.add("-clamp");
        return this;
    }

    public IMOps clip() {
        this.iCmdArgs.add("-clip");
        return this;
    }

    public IMOps clipMask() {
        this.iCmdArgs.add("-clip-mask");
        return this;
    }

    public IMOps clipPath() {
        this.iCmdArgs.add("-clip-path");
        return this;
    }

    public IMOps clipPath(String id) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-clip-path");
        if (id != null) {
            buf.append(id.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_clipPath() {
        this.iCmdArgs.add("+clip-path");
        return this;
    }

    public IMOps p_clipPath(String id) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+clip-path");
        if (id != null) {
            buf.append(id.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_clone() {
        this.iCmdArgs.add("+clone");
        return this;
    }

    public IMOps clone() {
        this.iCmdArgs.add("-clone");
        return this;
    }

    public IMOps clone(Integer index1) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-clone");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps clone(Integer index1, Integer index2) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-clone");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (index1 != null || index2 != null) {
            buf.append(",");
        }
        if (index2 != null) {
            buf.append(index2.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps clone(Integer index1, Integer index2, Integer index3) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-clone");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (index1 != null || index2 != null) {
            buf.append(",");
        }
        if (index2 != null) {
            buf.append(index2.toString());
        }
        if (index2 != null || index3 != null) {
            buf.append(",");
        }
        if (index3 != null) {
            buf.append(index3.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps clone(String indexes) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-clone");
        if (indexes != null) {
            buf.append(indexes.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps clut() {
        this.iCmdArgs.add("-clut");
        return this;
    }

    public IMOps coalesce() {
        this.iCmdArgs.add("-coalesce");
        return this;
    }

    public IMOps colorize() {
        this.iCmdArgs.add("-colorize");
        return this;
    }

    public IMOps colorize(Integer red) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colorize");
        if (red != null) {
            buf.append(red.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colorize(Integer red, Integer blue) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colorize");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || blue != null) {
            buf.append(",");
        }
        if (blue != null) {
            buf.append(blue.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colorize(Integer red, Integer blue, Integer green) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colorize");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || blue != null) {
            buf.append(",");
        }
        if (blue != null) {
            buf.append(blue.toString());
        }
        if (blue != null || green != null) {
            buf.append(",");
        }
        if (green != null) {
            buf.append(green.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colormap() {
        this.iCmdArgs.add("-colormap");
        return this;
    }

    public IMOps colormap(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colormap");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colorMatrix() {
        this.iCmdArgs.add("-color-matrix");
        return this;
    }

    public IMOps colorMatrix(String matrix) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-color-matrix");
        if (matrix != null) {
            buf.append(matrix.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colors() {
        this.iCmdArgs.add("-colors");
        return this;
    }

    public IMOps colors(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colors");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps colorspace() {
        this.iCmdArgs.add("-colorspace");
        return this;
    }

    public IMOps colorspace(String value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-colorspace");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps combine() {
        this.iCmdArgs.add("-combine");
        return this;
    }

    public IMOps comment() {
        this.iCmdArgs.add("-comment");
        return this;
    }

    public IMOps comment(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-comment");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps compose() {
        this.iCmdArgs.add("-compose");
        return this;
    }

    public IMOps compose(String operator) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-compose");
        if (operator != null) {
            buf.append(operator.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps composite() {
        this.iCmdArgs.add("-composite");
        return this;
    }

    public IMOps p_compress() {
        this.iCmdArgs.add("+compress");
        return this;
    }

    public IMOps compress() {
        this.iCmdArgs.add("-compress");
        return this;
    }

    public IMOps compress(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-compress");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps contrast() {
        this.iCmdArgs.add("-contrast");
        return this;
    }

    public IMOps p_contrast() {
        this.iCmdArgs.add("+contrast");
        return this;
    }

    public IMOps contrastStretch() {
        this.iCmdArgs.add("-contrast-stretch");
        return this;
    }

    public IMOps contrastStretch(Integer blackPoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-contrast-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps contrastStretch(Integer blackPoint, Integer whitePoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-contrast-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (blackPoint != null || whitePoint != null) {
            buf.append("x");
        }
        if (whitePoint != null) {
            buf.append(whitePoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps contrastStretch(Integer blackPoint, Integer whitePoint, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-contrast-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (blackPoint != null || whitePoint != null) {
            buf.append("x");
        }
        if (whitePoint != null) {
            buf.append(whitePoint.toString());
        }
        if (whitePoint != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve() {
        this.iCmdArgs.add("-convolve");
        return this;
    }

    public IMOps convolve(Integer k1) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (k11 != null || k12 != null) {
            buf.append(",");
        }
        if (k12 != null) {
            buf.append(k12.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (k11 != null || k12 != null) {
            buf.append(",");
        }
        if (k12 != null) {
            buf.append(k12.toString());
        }
        if (k12 != null || k13 != null) {
            buf.append(",");
        }
        if (k13 != null) {
            buf.append(k13.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (k11 != null || k12 != null) {
            buf.append(",");
        }
        if (k12 != null) {
            buf.append(k12.toString());
        }
        if (k12 != null || k13 != null) {
            buf.append(",");
        }
        if (k13 != null) {
            buf.append(k13.toString());
        }
        if (k13 != null || k14 != null) {
            buf.append(",");
        }
        if (k14 != null) {
            buf.append(k14.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (k11 != null || k12 != null) {
            buf.append(",");
        }
        if (k12 != null) {
            buf.append(k12.toString());
        }
        if (k12 != null || k13 != null) {
            buf.append(",");
        }
        if (k13 != null) {
            buf.append(k13.toString());
        }
        if (k13 != null || k14 != null) {
            buf.append(",");
        }
        if (k14 != null) {
            buf.append(k14.toString());
        }
        if (k14 != null || k15 != null) {
            buf.append(",");
        }
        if (k15 != null) {
            buf.append(k15.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15, Integer k16) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-convolve");
        if (k1 != null) {
            buf.append(k1.toString());
        }
        if (k1 != null || k2 != null) {
            buf.append(",");
        }
        if (k2 != null) {
            buf.append(k2.toString());
        }
        if (k2 != null || k3 != null) {
            buf.append(",");
        }
        if (k3 != null) {
            buf.append(k3.toString());
        }
        if (k3 != null || k4 != null) {
            buf.append(",");
        }
        if (k4 != null) {
            buf.append(k4.toString());
        }
        if (k4 != null || k5 != null) {
            buf.append(",");
        }
        if (k5 != null) {
            buf.append(k5.toString());
        }
        if (k5 != null || k6 != null) {
            buf.append(",");
        }
        if (k6 != null) {
            buf.append(k6.toString());
        }
        if (k6 != null || k7 != null) {
            buf.append(",");
        }
        if (k7 != null) {
            buf.append(k7.toString());
        }
        if (k7 != null || k8 != null) {
            buf.append(",");
        }
        if (k8 != null) {
            buf.append(k8.toString());
        }
        if (k8 != null || k9 != null) {
            buf.append(",");
        }
        if (k9 != null) {
            buf.append(k9.toString());
        }
        if (k9 != null || k10 != null) {
            buf.append(",");
        }
        if (k10 != null) {
            buf.append(k10.toString());
        }
        if (k10 != null || k11 != null) {
            buf.append(",");
        }
        if (k11 != null) {
            buf.append(k11.toString());
        }
        if (k11 != null || k12 != null) {
            buf.append(",");
        }
        if (k12 != null) {
            buf.append(k12.toString());
        }
        if (k12 != null || k13 != null) {
            buf.append(",");
        }
        if (k13 != null) {
            buf.append(k13.toString());
        }
        if (k13 != null || k14 != null) {
            buf.append(",");
        }
        if (k14 != null) {
            buf.append(k14.toString());
        }
        if (k14 != null || k15 != null) {
            buf.append(",");
        }
        if (k15 != null) {
            buf.append(k15.toString());
        }
        if (k15 != null || k16 != null) {
            buf.append(",");
        }
        if (k16 != null) {
            buf.append(k16.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop() {
        this.iCmdArgs.add("-crop");
        return this;
    }

    public IMOps crop(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop(Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop(Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop(Integer width, Integer height, Integer x, Integer y, Character special) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps crop(Integer width, Integer height, Integer x, Integer y, String special) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-crop");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps cycle() {
        this.iCmdArgs.add("-cycle");
        return this;
    }

    public IMOps cycle(Integer amount) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-cycle");
        if (amount != null) {
            buf.append(amount.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_debug() {
        this.iCmdArgs.add("+debug");
        return this;
    }

    public IMOps debug() {
        this.iCmdArgs.add("-debug");
        return this;
    }

    public IMOps debug(String events) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-debug");
        if (events != null) {
            buf.append(events.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps decipher() {
        this.iCmdArgs.add("-decipher");
        return this;
    }

    public IMOps decipher(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-decipher");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps deconstruct() {
        this.iCmdArgs.add("-deconstruct");
        return this;
    }

    public IMOps p_define() {
        this.iCmdArgs.add("+define");
        return this;
    }

    public IMOps p_define(String key) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+define");
        if (key != null) {
            buf.append(key.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps define() {
        this.iCmdArgs.add("-define");
        return this;
    }

    public IMOps define(String keyValue) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-define");
        if (keyValue != null) {
            buf.append(keyValue.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delay() {
        this.iCmdArgs.add("-delay");
        return this;
    }

    public IMOps delay(Integer ticks) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delay");
        if (ticks != null) {
            buf.append(ticks.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delay(Integer ticks, Integer ticksPerSecond) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delay");
        if (ticks != null) {
            buf.append(ticks.toString());
        }
        if (ticks != null || ticksPerSecond != null) {
            buf.append("x");
        }
        if (ticksPerSecond != null) {
            buf.append(ticksPerSecond.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delay(Integer ticks, Integer ticksPerSecond, Character special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delay");
        if (ticks != null) {
            buf.append(ticks.toString());
        }
        if (ticks != null || ticksPerSecond != null) {
            buf.append("x");
        }
        if (ticksPerSecond != null) {
            buf.append(ticksPerSecond.toString());
        }
        if (ticksPerSecond != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_delete() {
        this.iCmdArgs.add("+delete");
        return this;
    }

    public IMOps delete() {
        this.iCmdArgs.add("-delete");
        return this;
    }

    public IMOps delete(Integer index1) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delete");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delete(Integer index1, Integer index2) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delete");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (index1 != null || index2 != null) {
            buf.append(",");
        }
        if (index2 != null) {
            buf.append(index2.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delete(Integer index1, Integer index2, Integer index3) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delete");
        if (index1 != null) {
            buf.append(index1.toString());
        }
        if (index1 != null || index2 != null) {
            buf.append(",");
        }
        if (index2 != null) {
            buf.append(index2.toString());
        }
        if (index2 != null || index3 != null) {
            buf.append(",");
        }
        if (index3 != null) {
            buf.append(index3.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps delete(String indexes) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-delete");
        if (indexes != null) {
            buf.append(indexes.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps density() {
        this.iCmdArgs.add("-density");
        return this;
    }

    public IMOps density(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-density");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps density(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-density");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps depth() {
        this.iCmdArgs.add("-depth");
        return this;
    }

    public IMOps depth(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-depth");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps descend() {
        this.iCmdArgs.add("-descend");
        return this;
    }

    public IMOps deskew() {
        this.iCmdArgs.add("-deskew");
        return this;
    }

    public IMOps deskew(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-deskew");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps despeckle() {
        this.iCmdArgs.add("-despeckle");
        return this;
    }

    public IMOps direction() {
        this.iCmdArgs.add("-direction");
        return this;
    }

    public IMOps direction(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-direction");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps displace() {
        this.iCmdArgs.add("-displace");
        return this;
    }

    public IMOps displace(Double horizontalScale) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-displace");
        if (horizontalScale != null) {
            buf.append(horizontalScale.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps displace(Double horizontalScale, Double verticalScale) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-displace");
        if (horizontalScale != null) {
            buf.append(horizontalScale.toString());
        }
        if (horizontalScale != null || verticalScale != null) {
            buf.append("x");
        }
        if (verticalScale != null) {
            buf.append(verticalScale.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps display() {
        this.iCmdArgs.add("-display");
        return this;
    }

    public IMOps display(String host) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-display");
        if (host != null) {
            buf.append(host.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps display(String host, Integer display) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-display");
        if (host != null) {
            buf.append(host.toString());
        }
        if (host != null || display != null) {
            buf.append(":");
        }
        if (display != null) {
            buf.append(display.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps display(String host, Integer display, Integer screen) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-display");
        if (host != null) {
            buf.append(host.toString());
        }
        if (host != null || display != null) {
            buf.append(":");
        }
        if (display != null) {
            buf.append(display.toString());
        }
        if (display != null || screen != null) {
            buf.append(".");
        }
        if (screen != null) {
            buf.append(screen.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_dispose() {
        this.iCmdArgs.add("+dispose");
        return this;
    }

    public IMOps dispose() {
        this.iCmdArgs.add("-dispose");
        return this;
    }

    public IMOps dispose(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-dispose");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps dissimilarityThreshold() {
        this.iCmdArgs.add("-dissimilarity-threshold");
        return this;
    }

    public IMOps dissimilarityThreshold(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-dissimilarity-threshold");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps dissolve() {
        this.iCmdArgs.add("-dissolve");
        return this;
    }

    public IMOps dissolve(Integer percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-dissolve");
        if (percent != null) {
            buf.append(percent.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps distort() {
        this.iCmdArgs.add("-distort");
        return this;
    }

    public IMOps distort(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-distort");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps distort(String method, String arguments) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-distort");
        if (method != null) {
            buf.append(method.toString());
        }
        if (method != null || arguments != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (arguments != null) {
            buf.append(arguments.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_distort() {
        this.iCmdArgs.add("+distort");
        return this;
    }

    public IMOps p_distort(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+distort");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_distort(String method, String arguments) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+distort");
        if (method != null) {
            buf.append(method.toString());
        }
        if (method != null || arguments != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (arguments != null) {
            buf.append(arguments.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_dither() {
        this.iCmdArgs.add("+dither");
        return this;
    }

    public IMOps dither() {
        this.iCmdArgs.add("-dither");
        return this;
    }

    public IMOps dither(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-dither");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps draw() {
        this.iCmdArgs.add("-draw");
        return this;
    }

    public IMOps draw(String string) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-draw");
        if (string != null) {
            buf.append(string.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps duplicate() {
        this.iCmdArgs.add("-duplicate");
        return this;
    }

    public IMOps duplicate(Integer count) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-duplicate");
        if (count != null) {
            buf.append(count.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps duplicate(Integer count, String indices) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-duplicate");
        if (count != null) {
            buf.append(count.toString());
        }
        if (count != null || indices != null) {
            buf.append(",");
        }
        if (indices != null) {
            buf.append(indices.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_duplicate() {
        this.iCmdArgs.add("+duplicate");
        return this;
    }

    public IMOps edge() {
        this.iCmdArgs.add("-edge");
        return this;
    }

    public IMOps edge(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-edge");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps emboss() {
        this.iCmdArgs.add("-emboss");
        return this;
    }

    public IMOps emboss(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-emboss");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps encipher() {
        this.iCmdArgs.add("-encipher");
        return this;
    }

    public IMOps encipher(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-encipher");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps encoding() {
        this.iCmdArgs.add("-encoding");
        return this;
    }

    public IMOps encoding(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-encoding");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_endian() {
        this.iCmdArgs.add("+endian");
        return this;
    }

    public IMOps endian() {
        this.iCmdArgs.add("-endian");
        return this;
    }

    public IMOps endian(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-endian");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps enhance() {
        this.iCmdArgs.add("-enhance");
        return this;
    }

    public IMOps equalize() {
        this.iCmdArgs.add("-equalize");
        return this;
    }

    public IMOps evaluate() {
        this.iCmdArgs.add("-evaluate");
        return this;
    }

    public IMOps evaluate(String operator) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-evaluate");
        if (operator != null) {
            buf.append(operator.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps evaluate(String operator, String constant) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-evaluate");
        if (operator != null) {
            buf.append(operator.toString());
        }
        if (operator != null || constant != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (constant != null) {
            buf.append(constant.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps evaluateSequence() {
        this.iCmdArgs.add("-evaluate-sequence");
        return this;
    }

    public IMOps evaluateSequence(String operator) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-evaluate-sequence");
        if (operator != null) {
            buf.append(operator.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extent() {
        this.iCmdArgs.add("-extent");
        return this;
    }

    public IMOps extent(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extent");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extent(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extent");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extent(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extent");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extent(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extent");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extract() {
        this.iCmdArgs.add("-extract");
        return this;
    }

    public IMOps extract(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extract");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extract(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extract");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extract(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extract");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps extract(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-extract");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps family() {
        this.iCmdArgs.add("-family");
        return this;
    }

    public IMOps family(String fontFamily) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-family");
        if (fontFamily != null) {
            buf.append(fontFamily.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps features() {
        this.iCmdArgs.add("-features");
        return this;
    }

    public IMOps features(String distance) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-features");
        if (distance != null) {
            buf.append(distance.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps fft() {
        this.iCmdArgs.add("-fft");
        return this;
    }

    public IMOps fill() {
        this.iCmdArgs.add("-fill");
        return this;
    }

    public IMOps fill(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-fill");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps filter() {
        this.iCmdArgs.add("-filter");
        return this;
    }

    public IMOps filter(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-filter");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps flatten() {
        this.iCmdArgs.add("-flatten");
        return this;
    }

    public IMOps flip() {
        this.iCmdArgs.add("-flip");
        return this;
    }

    public IMOps floodfill() {
        this.iCmdArgs.add("-floodfill");
        return this;
    }

    public IMOps floodfill(Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-floodfill");
        String oper = "+";
        if (x.doubleValue() < 0.0) {
            oper = "";
        }
        buf.append(oper);
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps floodfill(Integer x, Integer y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-floodfill");
        String oper = "+";
        if (x.doubleValue() < 0.0) {
            oper = "";
        }
        buf.append(oper);
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps floodfill(Integer x, Integer y, String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-floodfill");
        String oper = "+";
        if (x.doubleValue() < 0.0) {
            oper = "";
        }
        buf.append(oper);
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || color != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps flop() {
        this.iCmdArgs.add("-flop");
        return this;
    }

    public IMOps font() {
        this.iCmdArgs.add("-font");
        return this;
    }

    public IMOps font(String name) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-font");
        if (name != null) {
            buf.append(name.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps foreground() {
        this.iCmdArgs.add("-foreground");
        return this;
    }

    public IMOps foreground(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-foreground");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps format() {
        this.iCmdArgs.add("-format");
        return this;
    }

    public IMOps format(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-format");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps frame() {
        this.iCmdArgs.add("-frame");
        return this;
    }

    public IMOps frame(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-frame");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps frame(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-frame");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps frame(Integer width, Integer height, Integer outerBevelWidth) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-frame");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || outerBevelWidth != null) {
            String oper = "+";
            if (outerBevelWidth.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (outerBevelWidth != null) {
            buf.append(outerBevelWidth.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps frame(Integer width, Integer height, Integer outerBevelWidth, Integer innerBevelWidth) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-frame");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || outerBevelWidth != null) {
            oper = "+";
            if (outerBevelWidth.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (outerBevelWidth != null) {
            buf.append(outerBevelWidth.toString());
        }
        if (outerBevelWidth != null || innerBevelWidth != null) {
            oper = "+";
            if (innerBevelWidth.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (innerBevelWidth != null) {
            buf.append(innerBevelWidth.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps function() {
        this.iCmdArgs.add("-function");
        return this;
    }

    public IMOps function(String name) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-function");
        if (name != null) {
            buf.append(name.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps function(String name, String parameter) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-function");
        if (name != null) {
            buf.append(name.toString());
        }
        if (name != null || parameter != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (parameter != null) {
            buf.append(parameter.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps fuzz() {
        this.iCmdArgs.add("-fuzz");
        return this;
    }

    public IMOps fuzz(Double distance) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-fuzz");
        if (distance != null) {
            buf.append(distance.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps fuzz(Double distance, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-fuzz");
        if (distance != null) {
            buf.append(distance.toString());
        }
        if (distance != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps fx() {
        this.iCmdArgs.add("-fx");
        return this;
    }

    public IMOps fx(String expression) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-fx");
        if (expression != null) {
            buf.append(expression.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps gamma() {
        this.iCmdArgs.add("-gamma");
        return this;
    }

    public IMOps gamma(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-gamma");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_gamma() {
        this.iCmdArgs.add("+gamma");
        return this;
    }

    public IMOps p_gamma(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+gamma");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps gaussianBlur() {
        this.iCmdArgs.add("-gaussian-blur");
        return this;
    }

    public IMOps gaussianBlur(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-gaussian-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps gaussianBlur(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-gaussian-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps geometry() {
        this.iCmdArgs.add("-geometry");
        return this;
    }

    public IMOps geometry(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-geometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps geometry(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-geometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps geometry(Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-geometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps geometry(Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-geometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps gravity() {
        this.iCmdArgs.add("-gravity");
        return this;
    }

    public IMOps gravity(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-gravity");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps greenPrimary() {
        this.iCmdArgs.add("-green-primary");
        return this;
    }

    public IMOps greenPrimary(Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-green-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps greenPrimary(Double x, Double y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-green-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            buf.append(",");
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps help() {
        this.iCmdArgs.add("-help");
        return this;
    }

    public IMOps haldClut() {
        this.iCmdArgs.add("-hald-clut");
        return this;
    }

    public IMOps highlightColor() {
        this.iCmdArgs.add("-highlight-color");
        return this;
    }

    public IMOps highlightColor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-highlight-color");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps iconGeometry() {
        this.iCmdArgs.add("-iconGeometry");
        return this;
    }

    public IMOps iconGeometry(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-iconGeometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps iconGeometry(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-iconGeometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps iconGeometry(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-iconGeometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps iconGeometry(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-iconGeometry");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps iconic() {
        this.iCmdArgs.add("-iconic");
        return this;
    }

    public IMOps identify() {
        this.iCmdArgs.add("-identify");
        return this;
    }

    public IMOps ift() {
        this.iCmdArgs.add("-ift");
        return this;
    }

    public IMOps immutable() {
        this.iCmdArgs.add("-immutable");
        return this;
    }

    public IMOps implode() {
        this.iCmdArgs.add("-implode");
        return this;
    }

    public IMOps implode(Double factor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-implode");
        if (factor != null) {
            buf.append(factor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps insert() {
        this.iCmdArgs.add("-insert");
        return this;
    }

    public IMOps insert(Integer index) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-insert");
        if (index != null) {
            buf.append(index.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps intent() {
        this.iCmdArgs.add("-intent");
        return this;
    }

    public IMOps intent(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-intent");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps interlace() {
        this.iCmdArgs.add("-interlace");
        return this;
    }

    public IMOps interlace(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-interlace");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps interlineSpacing() {
        this.iCmdArgs.add("-interline-spacing");
        return this;
    }

    public IMOps interlineSpacing(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-interline-spacing");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps interpolate() {
        this.iCmdArgs.add("-interpolate");
        return this;
    }

    public IMOps interpolate(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-interpolate");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps interwordSpacing() {
        this.iCmdArgs.add("-interword-spacing");
        return this;
    }

    public IMOps interwordSpacing(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-interword-spacing");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps kerning() {
        this.iCmdArgs.add("-kerning");
        return this;
    }

    public IMOps kerning(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-kerning");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_label() {
        this.iCmdArgs.add("+label");
        return this;
    }

    public IMOps label() {
        this.iCmdArgs.add("-label");
        return this;
    }

    public IMOps label(String name) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-label");
        if (name != null) {
            buf.append(name.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps lat() {
        this.iCmdArgs.add("-lat");
        return this;
    }

    public IMOps lat(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-lat");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps lat(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-lat");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps lat(Integer width, Integer height, Integer offset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-lat");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || offset != null) {
            String oper = "+";
            if (offset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (offset != null) {
            buf.append(offset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps lat(Integer width, Integer height, Integer offset, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-lat");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || offset != null) {
            String oper = "+";
            if (offset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (offset != null) {
            buf.append(offset.toString());
        }
        if (offset != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps layers() {
        this.iCmdArgs.add("-layers");
        return this;
    }

    public IMOps layers(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-layers");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps levelColors() {
        this.iCmdArgs.add("-level-colors");
        return this;
    }

    public IMOps levelColors(String black_color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level-colors");
        if (black_color != null) {
            buf.append(black_color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps levelColors(String black_color, String white_color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level-colors");
        if (black_color != null) {
            buf.append(black_color.toString());
        }
        if (black_color != null || white_color != null) {
            buf.append(",");
        }
        if (white_color != null) {
            buf.append(white_color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_levelColors() {
        this.iCmdArgs.add("+level-colors");
        return this;
    }

    public IMOps p_levelColors(String black_color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level-colors");
        if (black_color != null) {
            buf.append(black_color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_levelColors(String black_color, String white_color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level-colors");
        if (black_color != null) {
            buf.append(black_color.toString());
        }
        if (black_color != null || white_color != null) {
            buf.append(",");
        }
        if (white_color != null) {
            buf.append(white_color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps level() {
        this.iCmdArgs.add("-level");
        return this;
    }

    public IMOps level(Double black_point) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps level(Double black_point, Double white_point) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps level(Double black_point, Double white_point, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (white_point != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps level(Double black_point, Double white_point, Boolean percent, Double gamma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (white_point != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (percent != null || gamma != null) {
            buf.append(",");
        }
        if (gamma != null) {
            buf.append(gamma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_level() {
        this.iCmdArgs.add("+level");
        return this;
    }

    public IMOps p_level(Double black_point) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_level(Double black_point, Double white_point) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_level(Double black_point, Double white_point, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (white_point != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_level(Double black_point, Double white_point, Boolean percent, Double gamma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+level");
        if (black_point != null) {
            buf.append(black_point.toString());
        }
        if (black_point != null || white_point != null) {
            buf.append(",");
        }
        if (white_point != null) {
            buf.append(white_point.toString());
        }
        if (white_point != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (percent != null || gamma != null) {
            buf.append(",");
        }
        if (gamma != null) {
            buf.append(gamma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps limit() {
        this.iCmdArgs.add("-limit");
        return this;
    }

    public IMOps limit(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-limit");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps linearStretch() {
        this.iCmdArgs.add("-linear-stretch");
        return this;
    }

    public IMOps linearStretch(Double blackPoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-linear-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps linearStretch(Double blackPoint, Double whitePoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-linear-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (blackPoint != null || whitePoint != null) {
            buf.append("x");
        }
        if (whitePoint != null) {
            buf.append(whitePoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps linearStretch(Double blackPoint, Double whitePoint, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-linear-stretch");
        if (blackPoint != null) {
            buf.append(blackPoint.toString());
        }
        if (blackPoint != null || whitePoint != null) {
            buf.append("x");
        }
        if (whitePoint != null) {
            buf.append(whitePoint.toString());
        }
        if (whitePoint != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps linewidth() {
        this.iCmdArgs.add("-linewidth");
        return this;
    }

    public IMOps liquidRescale() {
        this.iCmdArgs.add("-liquid-rescale");
        return this;
    }

    public IMOps liquidRescale(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-liquid-rescale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps liquidRescale(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-liquid-rescale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps liquidRescale(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-liquid-rescale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps liquidRescale(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-liquid-rescale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps list() {
        this.iCmdArgs.add("-list");
        return this;
    }

    public IMOps list(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-list");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps log() {
        this.iCmdArgs.add("-log");
        return this;
    }

    public IMOps log(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-log");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps loop() {
        this.iCmdArgs.add("-loop");
        return this;
    }

    public IMOps loop(Integer iterations) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-loop");
        if (iterations != null) {
            buf.append(iterations.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps lowlightColor() {
        this.iCmdArgs.add("-lowlight-color");
        return this;
    }

    public IMOps lowlightColor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-lowlight-color");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps magnify() {
        this.iCmdArgs.add("-magnify");
        return this;
    }

    public IMOps magnify(Double factor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-magnify");
        if (factor != null) {
            buf.append(factor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_map() {
        this.iCmdArgs.add("+map");
        return this;
    }

    public IMOps map() {
        this.iCmdArgs.add("-map");
        return this;
    }

    public IMOps map(String components) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-map");
        if (components != null) {
            buf.append(components.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_mask() {
        this.iCmdArgs.add("+mask");
        return this;
    }

    public IMOps mask() {
        this.iCmdArgs.add("-mask");
        return this;
    }

    public IMOps mask(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-mask");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps mattecolor() {
        this.iCmdArgs.add("-mattecolor");
        return this;
    }

    public IMOps mattecolor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-mattecolor");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps median() {
        this.iCmdArgs.add("-median");
        return this;
    }

    public IMOps median(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-median");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps metric() {
        this.iCmdArgs.add("-metric");
        return this;
    }

    public IMOps metric(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-metric");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps mode() {
        this.iCmdArgs.add("-mode");
        return this;
    }

    public IMOps mode(String value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-mode");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps modulate() {
        this.iCmdArgs.add("-modulate");
        return this;
    }

    public IMOps modulate(Double brightness) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-modulate");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps modulate(Double brightness, Double saturation) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-modulate");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (brightness != null || saturation != null) {
            buf.append(",");
        }
        if (saturation != null) {
            buf.append(saturation.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps modulate(Double brightness, Double saturation, Double hue) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-modulate");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (brightness != null || saturation != null) {
            buf.append(",");
        }
        if (saturation != null) {
            buf.append(saturation.toString());
        }
        if (saturation != null || hue != null) {
            buf.append(",");
        }
        if (hue != null) {
            buf.append(hue.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps monitor() {
        this.iCmdArgs.add("-monitor");
        return this;
    }

    public IMOps monochrome() {
        this.iCmdArgs.add("-monochrome");
        return this;
    }

    public IMOps morph() {
        this.iCmdArgs.add("-morph");
        return this;
    }

    public IMOps morph(Integer frames) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-morph");
        if (frames != null) {
            buf.append(frames.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps morphology() {
        this.iCmdArgs.add("-morphology");
        return this;
    }

    public IMOps morphology(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-morphology");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps morphology(String method, String kernel) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-morphology");
        if (method != null) {
            buf.append(method.toString());
        }
        if (method != null || kernel != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (kernel != null) {
            buf.append(kernel.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps mosaic() {
        this.iCmdArgs.add("-mosaic");
        return this;
    }

    public IMOps motionBlur() {
        this.iCmdArgs.add("-motion-blur");
        return this;
    }

    public IMOps motionBlur(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-motion-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps motionBlur(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-motion-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps motionBlur(Double radius, Double sigma, Double angle) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-motion-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || angle != null) {
            String oper = "+";
            if (angle < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (angle != null) {
            buf.append(angle.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps name() {
        this.iCmdArgs.add("-name");
        return this;
    }

    public IMOps negate() {
        this.iCmdArgs.add("-negate");
        return this;
    }

    public IMOps p_negate() {
        this.iCmdArgs.add("+negate");
        return this;
    }

    public IMOps noise() {
        this.iCmdArgs.add("-noise");
        return this;
    }

    public IMOps noise(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-noise");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_noise() {
        this.iCmdArgs.add("+noise");
        return this;
    }

    public IMOps p_noise(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+noise");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps normalize() {
        this.iCmdArgs.add("-normalize");
        return this;
    }

    public IMOps opaque() {
        this.iCmdArgs.add("-opaque");
        return this;
    }

    public IMOps opaque(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-opaque");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_opaque() {
        this.iCmdArgs.add("+opaque");
        return this;
    }

    public IMOps p_opaque(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+opaque");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps orderedDither() {
        this.iCmdArgs.add("-ordered-dither");
        return this;
    }

    public IMOps orderedDither(String threshold_map) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-ordered-dither");
        if (threshold_map != null) {
            buf.append(threshold_map.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps orderedDither(String threshold_map, String level) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-ordered-dither");
        if (threshold_map != null) {
            buf.append(threshold_map.toString());
        }
        if (threshold_map != null || level != null) {
            buf.append(",");
        }
        if (level != null) {
            buf.append(level.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps orient() {
        this.iCmdArgs.add("-orient");
        return this;
    }

    public IMOps orient(String imageOrientation) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-orient");
        if (imageOrientation != null) {
            buf.append(imageOrientation.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_page() {
        this.iCmdArgs.add("+page");
        return this;
    }

    public IMOps page() {
        this.iCmdArgs.add("-page");
        return this;
    }

    public IMOps page(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps page(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps page(Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps page(Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps page(Integer width, Integer height, Integer x, Integer y, Character special) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps page(Integer width, Integer height, Integer x, Integer y, String special) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-page");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps paint() {
        this.iCmdArgs.add("-paint");
        return this;
    }

    public IMOps paint(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-paint");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps path() {
        this.iCmdArgs.add("-path");
        return this;
    }

    public IMOps path(String path) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-path");
        if (path != null) {
            buf.append(path.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps passphrase() {
        this.iCmdArgs.add("-passphrase");
        return this;
    }

    public IMOps passphrase(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-passphrase");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps pause() {
        this.iCmdArgs.add("-pause");
        return this;
    }

    public IMOps pause(Integer seconds) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-pause");
        if (seconds != null) {
            buf.append(seconds.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps perceptible() {
        this.iCmdArgs.add("-perceptible");
        return this;
    }

    public IMOps perceptible(Double epsilon) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-perceptible");
        if (epsilon != null) {
            buf.append(epsilon.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps ping() {
        this.iCmdArgs.add("-ping");
        return this;
    }

    public IMOps pointsize() {
        this.iCmdArgs.add("-pointsize");
        return this;
    }

    public IMOps pointsize(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-pointsize");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps polaroid() {
        this.iCmdArgs.add("-polaroid");
        return this;
    }

    public IMOps polaroid(Double angle) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-polaroid");
        if (angle != null) {
            buf.append(angle.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_polaroid() {
        this.iCmdArgs.add("+polaroid");
        return this;
    }

    public IMOps poly() {
        this.iCmdArgs.add("-poly");
        return this;
    }

    public IMOps poly(String args) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-poly");
        if (args != null) {
            buf.append(args.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps posterize() {
        this.iCmdArgs.add("-posterize");
        return this;
    }

    public IMOps posterize(Integer levels) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-posterize");
        if (levels != null) {
            buf.append(levels.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps precision() {
        this.iCmdArgs.add("-precision");
        return this;
    }

    public IMOps precision(Integer digits) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-precision");
        if (digits != null) {
            buf.append(digits.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps preview() {
        this.iCmdArgs.add("-preview");
        return this;
    }

    public IMOps preview(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-preview");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps print() {
        this.iCmdArgs.add("-print");
        return this;
    }

    public IMOps print(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-print");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps process() {
        this.iCmdArgs.add("-process");
        return this;
    }

    public IMOps process(String command) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-process");
        if (command != null) {
            buf.append(command.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps profile() {
        this.iCmdArgs.add("-profile");
        return this;
    }

    public IMOps profile(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-profile");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_profile() {
        this.iCmdArgs.add("+profile");
        return this;
    }

    public IMOps p_profile(String profileName) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+profile");
        if (profileName != null) {
            buf.append(profileName.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps quality() {
        this.iCmdArgs.add("-quality");
        return this;
    }

    public IMOps quality(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-quality");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps quantize() {
        this.iCmdArgs.add("-quantize");
        return this;
    }

    public IMOps quantize(String colorspace) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-quantize");
        if (colorspace != null) {
            buf.append(colorspace.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps quiet() {
        this.iCmdArgs.add("-quiet");
        return this;
    }

    public IMOps radialBlur() {
        this.iCmdArgs.add("-radial-blur");
        return this;
    }

    public IMOps radialBlur(Double angle) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-radial-blur");
        if (angle != null) {
            buf.append(angle.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps raise() {
        this.iCmdArgs.add("-raise");
        return this;
    }

    public IMOps raise(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-raise");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps raise(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-raise");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_raise() {
        this.iCmdArgs.add("+raise");
        return this;
    }

    public IMOps p_raise(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+raise");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_raise(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+raise");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps randomThreshold() {
        this.iCmdArgs.add("-random-threshold");
        return this;
    }

    public IMOps randomThreshold(Double low) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-random-threshold");
        if (low != null) {
            buf.append(low.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps randomThreshold(Double low, Double high) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-random-threshold");
        if (low != null) {
            buf.append(low.toString());
        }
        if (low != null || high != null) {
            buf.append("x");
        }
        if (high != null) {
            buf.append(high.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps randomThreshold(Double low, Double high, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-random-threshold");
        if (low != null) {
            buf.append(low.toString());
        }
        if (low != null || high != null) {
            buf.append("x");
        }
        if (high != null) {
            buf.append(high.toString());
        }
        if (high != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps recolor() {
        this.iCmdArgs.add("-recolor");
        return this;
    }

    public IMOps recolor(String matrix) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-recolor");
        if (matrix != null) {
            buf.append(matrix.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps redPrimary() {
        this.iCmdArgs.add("-red-primary");
        return this;
    }

    public IMOps redPrimary(Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-red-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps redPrimary(Double x, Double y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-red-primary");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            buf.append(",");
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps regardWarnings() {
        this.iCmdArgs.add("-regard-warnings");
        return this;
    }

    public IMOps region() {
        this.iCmdArgs.add("-region");
        return this;
    }

    public IMOps region(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-region");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps region(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-region");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps region(Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-region");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps region(Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-region");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_remap() {
        this.iCmdArgs.add("+remap");
        return this;
    }

    public IMOps remap() {
        this.iCmdArgs.add("-remap");
        return this;
    }

    public IMOps remap(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-remap");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps remote() {
        this.iCmdArgs.add("-remote");
        return this;
    }

    public IMOps render() {
        this.iCmdArgs.add("-render");
        return this;
    }

    public IMOps p_render() {
        this.iCmdArgs.add("+render");
        return this;
    }

    public IMOps p_repage() {
        this.iCmdArgs.add("+repage");
        return this;
    }

    public IMOps repage() {
        this.iCmdArgs.add("-repage");
        return this;
    }

    public IMOps repage(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-repage");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps repage(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-repage");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps repage(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-repage");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps repage(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-repage");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resample() {
        this.iCmdArgs.add("-resample");
        return this;
    }

    public IMOps resample(Integer horizontal) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resample");
        if (horizontal != null) {
            buf.append(horizontal.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resample(Integer horizontal, Integer vertical) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resample");
        if (horizontal != null) {
            buf.append(horizontal.toString());
        }
        if (horizontal != null || vertical != null) {
            buf.append("x");
        }
        if (vertical != null) {
            buf.append(vertical.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resize() {
        this.iCmdArgs.add("-resize");
        return this;
    }

    public IMOps resize(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resize(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resize(Integer width, Integer height, Character special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps resize(Integer width, Integer height, String special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-resize");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps respectParentheses() {
        this.iCmdArgs.add("-respect-parentheses");
        return this;
    }

    public IMOps respectParenthesis() {
        this.iCmdArgs.add("-respect-parenthesis");
        return this;
    }

    public IMOps reverse() {
        this.iCmdArgs.add("-reverse");
        return this;
    }

    public IMOps roll() {
        this.iCmdArgs.add("-roll");
        return this;
    }

    public IMOps roll(Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-roll");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps roll(Integer x, Integer y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-roll");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            String oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps rotate() {
        this.iCmdArgs.add("-rotate");
        return this;
    }

    public IMOps rotate(Double degrees) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-rotate");
        if (degrees != null) {
            buf.append(degrees.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps rotate(Double degrees, Character special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-rotate");
        if (degrees != null) {
            buf.append(degrees.toString());
        }
        if (degrees != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sample() {
        this.iCmdArgs.add("-sample");
        return this;
    }

    public IMOps sample(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sample");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sample(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sample");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sample(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sample");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sample(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sample");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps samplingFactor() {
        this.iCmdArgs.add("-sampling-factor");
        return this;
    }

    public IMOps samplingFactor(Double horizontalFactor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sampling-factor");
        if (horizontalFactor != null) {
            buf.append(horizontalFactor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps samplingFactor(Double horizontalFactor, Double verticalFactor) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sampling-factor");
        if (horizontalFactor != null) {
            buf.append(horizontalFactor.toString());
        }
        if (horizontalFactor != null || verticalFactor != null) {
            buf.append("x");
        }
        if (verticalFactor != null) {
            buf.append(verticalFactor.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps selectiveBlur() {
        this.iCmdArgs.add("-selective-blur");
        return this;
    }

    public IMOps selectiveBlur(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-selective-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps selectiveBlur(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-selective-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps selectiveBlur(Double radius, Double sigma, Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-selective-blur");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || threshold != null) {
            String oper = "+";
            if (threshold < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sparseColor() {
        this.iCmdArgs.add("-sparse-color");
        return this;
    }

    public IMOps sparseColor(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sparse-color");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sparseColor(String method, String cinfo) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sparse-color");
        if (method != null) {
            buf.append(method.toString());
        }
        if (method != null || cinfo != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (cinfo != null) {
            buf.append(cinfo.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps scale() {
        this.iCmdArgs.add("-scale");
        return this;
    }

    public IMOps scale(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-scale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps scale(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-scale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps scale(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-scale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps scale(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-scale");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps scene() {
        this.iCmdArgs.add("-scene");
        return this;
    }

    public IMOps scene(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-scene");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps screen() {
        this.iCmdArgs.add("-screen");
        return this;
    }

    public IMOps seed() {
        this.iCmdArgs.add("-seed");
        return this;
    }

    public IMOps segment() {
        this.iCmdArgs.add("-segment");
        return this;
    }

    public IMOps segment(Integer clusterThreshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-segment");
        if (clusterThreshold != null) {
            buf.append(clusterThreshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps segment(Integer clusterThreshold, Double smoothingThreshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-segment");
        if (clusterThreshold != null) {
            buf.append(clusterThreshold.toString());
        }
        if (clusterThreshold != null || smoothingThreshold != null) {
            buf.append("x");
        }
        if (smoothingThreshold != null) {
            buf.append(smoothingThreshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps separate() {
        this.iCmdArgs.add("-separate");
        return this;
    }

    public IMOps sepiaTone() {
        this.iCmdArgs.add("-sepia-tone");
        return this;
    }

    public IMOps sepiaTone(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sepia-tone");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps set() {
        this.iCmdArgs.add("-set");
        return this;
    }

    public IMOps set(String attribute) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-set");
        if (attribute != null) {
            buf.append(attribute.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps set(String attribute, String value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-set");
        if (attribute != null) {
            buf.append(attribute.toString());
        }
        if (attribute != null || value != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shade() {
        this.iCmdArgs.add("-shade");
        return this;
    }

    public IMOps shade(Double azimuth) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shade");
        if (azimuth != null) {
            buf.append(azimuth.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shade(Double azimuth, Double elevation) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shade");
        if (azimuth != null) {
            buf.append(azimuth.toString());
        }
        if (azimuth != null || elevation != null) {
            buf.append("x");
        }
        if (elevation != null) {
            buf.append(elevation.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_shade() {
        this.iCmdArgs.add("+shade");
        return this;
    }

    public IMOps p_shade(Double azimuth) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+shade");
        if (azimuth != null) {
            buf.append(azimuth.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_shade(Double azimuth, Double elevation) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+shade");
        if (azimuth != null) {
            buf.append(azimuth.toString());
        }
        if (azimuth != null || elevation != null) {
            buf.append("x");
        }
        if (elevation != null) {
            buf.append(elevation.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shadow() {
        this.iCmdArgs.add("-shadow");
        return this;
    }

    public IMOps shadow(Integer percentOpacity) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shadow");
        if (percentOpacity != null) {
            buf.append(percentOpacity.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shadow(Integer percentOpacity, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shadow");
        if (percentOpacity != null) {
            buf.append(percentOpacity.toString());
        }
        if (percentOpacity != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shadow(Integer percentOpacity, Double sigma, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shadow");
        if (percentOpacity != null) {
            buf.append(percentOpacity.toString());
        }
        if (percentOpacity != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shadow(Integer percentOpacity, Double sigma, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shadow");
        if (percentOpacity != null) {
            buf.append(percentOpacity.toString());
        }
        if (percentOpacity != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shadow(Integer percentOpacity, Double sigma, Integer x, Integer y, Boolean percent) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shadow");
        if (percentOpacity != null) {
            buf.append(percentOpacity.toString());
        }
        if (percentOpacity != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sharedMemory() {
        this.iCmdArgs.add("-shared-memory");
        return this;
    }

    public IMOps sharpen() {
        this.iCmdArgs.add("-sharpen");
        return this;
    }

    public IMOps sharpen(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sharpen");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sharpen(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sharpen");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shave() {
        this.iCmdArgs.add("-shave");
        return this;
    }

    public IMOps shave(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shave");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shave(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shave");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shave(Integer width, Integer height, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shave");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shear() {
        this.iCmdArgs.add("-shear");
        return this;
    }

    public IMOps shear(Double xDegrees) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shear");
        if (xDegrees != null) {
            buf.append(xDegrees.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps shear(Double xDegrees, Double yDegrees) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-shear");
        if (xDegrees != null) {
            buf.append(xDegrees.toString());
        }
        if (xDegrees != null || yDegrees != null) {
            buf.append("x");
        }
        if (yDegrees != null) {
            buf.append(yDegrees.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sigmoidalContrast() {
        this.iCmdArgs.add("-sigmoidal-contrast");
        return this;
    }

    public IMOps sigmoidalContrast(Double contrast) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sigmoidal-contrast");
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sigmoidalContrast(Double contrast, Double midPoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sigmoidal-contrast");
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (contrast != null || midPoint != null) {
            buf.append("x");
        }
        if (midPoint != null) {
            buf.append(midPoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_sigmoidalContrast() {
        this.iCmdArgs.add("+sigmoidal-contrast");
        return this;
    }

    public IMOps p_sigmoidalContrast(Double contrast) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+sigmoidal-contrast");
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_sigmoidalContrast(Double contrast, Double midPoint) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+sigmoidal-contrast");
        if (contrast != null) {
            buf.append(contrast.toString());
        }
        if (contrast != null || midPoint != null) {
            buf.append("x");
        }
        if (midPoint != null) {
            buf.append(midPoint.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps silent() {
        this.iCmdArgs.add("-silent");
        return this;
    }

    public IMOps size() {
        this.iCmdArgs.add("-size");
        return this;
    }

    public IMOps size(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-size");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps size(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-size");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps size(Integer width, Integer height, Integer offset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-size");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || offset != null) {
            String oper = "+";
            if (offset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (offset != null) {
            buf.append(offset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sketch() {
        this.iCmdArgs.add("-sketch");
        return this;
    }

    public IMOps sketch(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sketch");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sketch(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sketch");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps sketch(Double radius, Double sigma, Double angle) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-sketch");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || angle != null) {
            String oper = "+";
            if (angle < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (angle != null) {
            buf.append(angle.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps smush() {
        this.iCmdArgs.add("-smush");
        return this;
    }

    public IMOps smush(Integer offset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-smush");
        if (offset != null) {
            buf.append(offset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps snaps() {
        this.iCmdArgs.add("-snaps");
        return this;
    }

    public IMOps snaps(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-snaps");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps solarize() {
        this.iCmdArgs.add("-solarize");
        return this;
    }

    public IMOps solarize(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-solarize");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps splice() {
        this.iCmdArgs.add("-splice");
        return this;
    }

    public IMOps splice(Double width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-splice");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps splice(Double width, Double height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-splice");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps splice(Double width, Double height, Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-splice");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps splice(Double width, Double height, Double x, Double y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-splice");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps splice(Double width, Double height, Double x, Double y, Boolean percent) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-splice");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps spread() {
        this.iCmdArgs.add("-spread");
        return this;
    }

    public IMOps spread(Integer amount) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-spread");
        if (amount != null) {
            buf.append(amount.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps stegano() {
        this.iCmdArgs.add("-stegano");
        return this;
    }

    public IMOps stegano(Integer offset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-stegano");
        if (offset != null) {
            buf.append(offset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps stereo() {
        this.iCmdArgs.add("-stereo");
        return this;
    }

    public IMOps stereo(Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-stereo");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps stereo(Integer x, Integer y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-stereo");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            String oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic() {
        this.iCmdArgs.add("-statistic");
        return this;
    }

    public IMOps statistic(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic(String type, Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (type != null || width != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic(String type, Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (type != null || width != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic(String type, Integer width, Integer height, Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (type != null || width != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            String oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic(String type, Integer width, Integer height, Integer x, Integer y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (type != null || width != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps statistic(String type, Integer width, Integer height, Integer x, Integer y, String special) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-statistic");
        if (type != null) {
            buf.append(type.toString());
        }
        if (type != null || width != null) {
            this.iCmdArgs.add(buf.toString());
            buf.setLength(0);
        }
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || x != null) {
            oper = "+";
            if (x.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps storageType() {
        this.iCmdArgs.add("-storage-type");
        return this;
    }

    public IMOps storageType(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-storage-type");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps stretch() {
        this.iCmdArgs.add("-stretch");
        return this;
    }

    public IMOps stretch(String fontStretchType) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-stretch");
        if (fontStretchType != null) {
            buf.append(fontStretchType.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps strip() {
        this.iCmdArgs.add("-strip");
        return this;
    }

    public IMOps stroke() {
        this.iCmdArgs.add("-stroke");
        return this;
    }

    public IMOps stroke(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-stroke");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps strokewidth() {
        this.iCmdArgs.add("-strokewidth");
        return this;
    }

    public IMOps strokewidth(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-strokewidth");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps style() {
        this.iCmdArgs.add("-style");
        return this;
    }

    public IMOps style(String fontStyle) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-style");
        if (fontStyle != null) {
            buf.append(fontStyle.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps subimageSearch() {
        this.iCmdArgs.add("-subimage-search");
        return this;
    }

    public IMOps p_swap() {
        this.iCmdArgs.add("+swap");
        return this;
    }

    public IMOps swap() {
        this.iCmdArgs.add("-swap");
        return this;
    }

    public IMOps swap(Integer pos1) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-swap");
        if (pos1 != null) {
            buf.append(pos1.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps swap(Integer pos1, Integer pos2) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-swap");
        if (pos1 != null) {
            buf.append(pos1.toString());
        }
        if (pos1 != null || pos2 != null) {
            buf.append(",");
        }
        if (pos2 != null) {
            buf.append(pos2.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps swirl() {
        this.iCmdArgs.add("-swirl");
        return this;
    }

    public IMOps swirl(Double degrees) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-swirl");
        if (degrees != null) {
            buf.append(degrees.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps synchronize() {
        this.iCmdArgs.add("-synchronize");
        return this;
    }

    public IMOps taint() {
        this.iCmdArgs.add("-taint");
        return this;
    }

    public IMOps textFont() {
        this.iCmdArgs.add("-text-font");
        return this;
    }

    public IMOps textFont(String name) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-text-font");
        if (name != null) {
            buf.append(name.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps texture() {
        this.iCmdArgs.add("-texture");
        return this;
    }

    public IMOps texture(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-texture");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps threshold() {
        this.iCmdArgs.add("-threshold");
        return this;
    }

    public IMOps threshold(Integer red) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-threshold");
        if (red != null) {
            buf.append(red.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps threshold(Integer red, Integer green) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-threshold");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || green != null) {
            buf.append(",");
        }
        if (green != null) {
            buf.append(green.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps threshold(Integer red, Integer green, Integer blue) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-threshold");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || green != null) {
            buf.append(",");
        }
        if (green != null) {
            buf.append(green.toString());
        }
        if (green != null || blue != null) {
            buf.append(",");
        }
        if (blue != null) {
            buf.append(blue.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps threshold(Integer red, Integer green, Integer blue, Integer opacity) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-threshold");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || green != null) {
            buf.append(",");
        }
        if (green != null) {
            buf.append(green.toString());
        }
        if (green != null || blue != null) {
            buf.append(",");
        }
        if (blue != null) {
            buf.append(blue.toString());
        }
        if (blue != null || opacity != null) {
            buf.append(",");
        }
        if (opacity != null) {
            buf.append(opacity.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps threshold(Integer red, Integer green, Integer blue, Integer opacity, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-threshold");
        if (red != null) {
            buf.append(red.toString());
        }
        if (red != null || green != null) {
            buf.append(",");
        }
        if (green != null) {
            buf.append(green.toString());
        }
        if (green != null || blue != null) {
            buf.append(",");
        }
        if (blue != null) {
            buf.append(blue.toString());
        }
        if (blue != null || opacity != null) {
            buf.append(",");
        }
        if (opacity != null) {
            buf.append(opacity.toString());
        }
        if (opacity != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps thumbnail() {
        this.iCmdArgs.add("-thumbnail");
        return this;
    }

    public IMOps thumbnail(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-thumbnail");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps thumbnail(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-thumbnail");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps thumbnail(Integer width, Integer height, Character special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-thumbnail");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps thumbnail(Integer width, Integer height, String special) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-thumbnail");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || special != null) {
            // empty if block
        }
        if (special != null) {
            buf.append(special.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tile() {
        this.iCmdArgs.add("-tile");
        return this;
    }

    public IMOps tile(Integer width) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile");
        if (width != null) {
            buf.append(width.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tile(Integer width, Integer height) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tile(Integer width, Integer height, Integer xOffset) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            String oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tile(Integer width, Integer height, Integer xOffset, Integer yOffset) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile");
        if (width != null) {
            buf.append(width.toString());
        }
        if (width != null || height != null) {
            buf.append("x");
        }
        if (height != null) {
            buf.append(height.toString());
        }
        if (height != null || xOffset != null) {
            oper = "+";
            if (xOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (xOffset != null) {
            buf.append(xOffset.toString());
        }
        if (xOffset != null || yOffset != null) {
            oper = "+";
            if (yOffset.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (yOffset != null) {
            buf.append(yOffset.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tileOffset() {
        this.iCmdArgs.add("-tile-offset");
        return this;
    }

    public IMOps tileOffset(Integer x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile-offset");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tileOffset(Integer x, Integer y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile-offset");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            String oper = "+";
            if (y.doubleValue() < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tile(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tile");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps tint() {
        this.iCmdArgs.add("-tint");
        return this;
    }

    public IMOps tint(Double value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-tint");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps title() {
        this.iCmdArgs.add("-title");
        return this;
    }

    public IMOps title(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-title");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps transform() {
        this.iCmdArgs.add("-transform");
        return this;
    }

    public IMOps transparentColor() {
        this.iCmdArgs.add("-transparent-color");
        return this;
    }

    public IMOps transparentColor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-transparent-color");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps transparent() {
        this.iCmdArgs.add("-transparent");
        return this;
    }

    public IMOps transparent(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-transparent");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps transpose() {
        this.iCmdArgs.add("-transpose");
        return this;
    }

    public IMOps transverse() {
        this.iCmdArgs.add("-transverse");
        return this;
    }

    public IMOps treedepth() {
        this.iCmdArgs.add("-treedepth");
        return this;
    }

    public IMOps treedepth(Integer value) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-treedepth");
        if (value != null) {
            buf.append(value.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps trim() {
        this.iCmdArgs.add("-trim");
        return this;
    }

    public IMOps type() {
        this.iCmdArgs.add("-type");
        return this;
    }

    public IMOps type(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-type");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps undercolor() {
        this.iCmdArgs.add("-undercolor");
        return this;
    }

    public IMOps undercolor(String color) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-undercolor");
        if (color != null) {
            buf.append(color.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps uniqueColors() {
        this.iCmdArgs.add("-unique-colors");
        return this;
    }

    public IMOps units() {
        this.iCmdArgs.add("-units");
        return this;
    }

    public IMOps units(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-units");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps unsharp() {
        this.iCmdArgs.add("-unsharp");
        return this;
    }

    public IMOps unsharp(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-unsharp");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps unsharp(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-unsharp");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps unsharp(Double radius, Double sigma, Double amount) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-unsharp");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || amount != null) {
            String oper = "+";
            if (amount < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (amount != null) {
            buf.append(amount.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps unsharp(Double radius, Double sigma, Double amount, Double threshold) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-unsharp");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || amount != null) {
            oper = "+";
            if (amount < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (amount != null) {
            buf.append(amount.toString());
        }
        if (amount != null || threshold != null) {
            oper = "+";
            if (threshold < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps update() {
        this.iCmdArgs.add("-update");
        return this;
    }

    public IMOps update(Integer seconds) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-update");
        if (seconds != null) {
            buf.append(seconds.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps verbose() {
        this.iCmdArgs.add("-verbose");
        return this;
    }

    public IMOps version() {
        this.iCmdArgs.add("-version");
        return this;
    }

    public IMOps view() {
        this.iCmdArgs.add("-view");
        return this;
    }

    public IMOps view(String text) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-view");
        if (text != null) {
            buf.append(text.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps vignette() {
        this.iCmdArgs.add("-vignette");
        return this;
    }

    public IMOps vignette(Double radius) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-vignette");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps vignette(Double radius, Double sigma) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-vignette");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps vignette(Double radius, Double sigma, Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-vignette");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            String oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps vignette(Double radius, Double sigma, Double x, Double y) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-vignette");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps vignette(Double radius, Double sigma, Double x, Double y, Boolean percent) {
        String oper;
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-vignette");
        if (radius != null) {
            buf.append(radius.toString());
        }
        if (radius != null || sigma != null) {
            buf.append("x");
        }
        if (sigma != null) {
            buf.append(sigma.toString());
        }
        if (sigma != null || x != null) {
            oper = "+";
            if (x < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            oper = "+";
            if (y < 0.0) {
                oper = "";
            }
            buf.append(oper);
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (y != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps virtualPixel() {
        this.iCmdArgs.add("-virtual-pixel");
        return this;
    }

    public IMOps virtualPixel(String method) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-virtual-pixel");
        if (method != null) {
            buf.append(method.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps visual() {
        this.iCmdArgs.add("-visual");
        return this;
    }

    public IMOps visual(String type) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-visual");
        if (type != null) {
            buf.append(type.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps watermark() {
        this.iCmdArgs.add("-watermark");
        return this;
    }

    public IMOps watermark(Double brightness) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-watermark");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps watermark(Double brightness, Double saturation) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-watermark");
        if (brightness != null) {
            buf.append(brightness.toString());
        }
        if (brightness != null || saturation != null) {
            buf.append("x");
        }
        if (saturation != null) {
            buf.append(saturation.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps wave() {
        this.iCmdArgs.add("-wave");
        return this;
    }

    public IMOps wave(Double amplitude) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-wave");
        if (amplitude != null) {
            buf.append(amplitude.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps wave(Double amplitude, Double wavelength) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-wave");
        if (amplitude != null) {
            buf.append(amplitude.toString());
        }
        if (amplitude != null || wavelength != null) {
            buf.append("x");
        }
        if (wavelength != null) {
            buf.append(wavelength.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps weight() {
        this.iCmdArgs.add("-weight");
        return this;
    }

    public IMOps weight(String fontWeight) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-weight");
        if (fontWeight != null) {
            buf.append(fontWeight.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps weight(Integer fontWeight) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-weight");
        if (fontWeight != null) {
            buf.append(fontWeight.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps whitePoint() {
        this.iCmdArgs.add("-white-point");
        return this;
    }

    public IMOps whitePoint(Double x) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-white-point");
        if (x != null) {
            buf.append(x.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps whitePoint(Double x, Double y) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-white-point");
        if (x != null) {
            buf.append(x.toString());
        }
        if (x != null || y != null) {
            buf.append(",");
        }
        if (y != null) {
            buf.append(y.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps whiteThreshold() {
        this.iCmdArgs.add("-white-threshold");
        return this;
    }

    public IMOps whiteThreshold(Double threshold) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-white-threshold");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps whiteThreshold(Double threshold, Boolean percent) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-white-threshold");
        if (threshold != null) {
            buf.append(threshold.toString());
        }
        if (threshold != null || percent != null) {
            // empty if block
        }
        if (percent != null && percent.booleanValue()) {
            buf.append("%");
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps windowGroup() {
        this.iCmdArgs.add("-window-group");
        return this;
    }

    public IMOps window() {
        this.iCmdArgs.add("-window");
        return this;
    }

    public IMOps window(String id) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-window");
        if (id != null) {
            buf.append(id.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps write() {
        this.iCmdArgs.add("-write");
        return this;
    }

    public IMOps write(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("-write");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }

    public IMOps p_write() {
        this.iCmdArgs.add("+write");
        return this;
    }

    public IMOps p_write(String filename) {
        StringBuffer buf = new StringBuffer();
        this.iCmdArgs.add("+write");
        if (filename != null) {
            buf.append(filename.toString());
        }
        if (buf.length() > 0) {
            this.iCmdArgs.add(buf.toString());
        }
        return this;
    }
}

