/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.process;

import com.github.geko444.im4java.process.ErrorConsumer;
import com.github.geko444.im4java.process.InputProvider;
import com.github.geko444.im4java.process.OutputConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Pipe
implements InputProvider,
OutputConsumer,
ErrorConsumer {
    public static final int BUFFER_SIZE = 65536;
    private InputStream iSource;
    private OutputStream iSink;

    public Pipe(InputStream pSource, OutputStream pSink) {
        this.iSource = pSource;
        this.iSink = pSink;
    }

    @Override
    public void provideInput(OutputStream pOutputStream) throws IOException {
        this.copyBytes(this.iSource, pOutputStream);
    }

    @Override
    public void consumeOutput(InputStream pInputStream) throws IOException {
        if (this.iSink != null) {
            this.copyBytes(pInputStream, this.iSink);
        }
    }

    @Override
    public void consumeError(InputStream pInputStream) throws IOException {
        if (this.iSink != null) {
            this.copyBytes(pInputStream, this.iSink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBytes(InputStream pIs, OutputStream pOs) throws IOException {
        int byteCount;
        byte[] buffer = new byte[65536];
        while ((byteCount = pIs.read(buffer)) != -1) {
            OutputStream outputStream = pOs;
            synchronized (outputStream) {
                pOs.write(buffer, 0, byteCount);
            }
        }
        pOs.flush();
    }
}

