/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.script;

import com.github.geko444.im4java.core.ImageCommand;
import com.github.geko444.im4java.core.Operation;
import com.github.geko444.im4java.script.ScriptGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Properties;

public abstract class AbstractScriptGenerator
implements ScriptGenerator {
    protected static final int LINE_SIZE = 78;
    protected char ESC_EOL;
    protected char ESC_SPECIAL;
    protected String iIndent = "";
    protected StringBuilder iLineBuffer = null;
    protected int iArgIndex = 0;
    private Properties iProps = null;
    private PrintWriter iWriter = null;
    private ImageCommand iCmd = null;
    private Operation iOp = null;

    @Override
    public void createScript() {
        this.iIndent = "";
        this.iArgIndex = 0;
        this.writeHeader();
        this.writeCommand();
        this.writeOperation();
        this.getWriter().flush();
    }

    protected void writeHeader() {
    }

    protected String getSearchPath() {
        String globalPath = this.getProperties().getProperty("im4java.globalSearchPath");
        String localPath = this.getProperties().getProperty("im4java.localSearchPath");
        String path = null;
        if (localPath.length() > 0 && globalPath.length() > 0) {
            path = localPath + File.pathSeparator + globalPath;
        } else if (localPath.length() > 0 && globalPath.length() == 0) {
            path = localPath;
        } else if (globalPath.length() > 0) {
            path = globalPath;
        }
        return path;
    }

    protected void writeCommand() {
        PrintWriter writer = this.getWriter();
        writer.print(this.iProps.getProperty("im4java.cmd"));
        writer.println(this.ESC_EOL);
        this.iIndent = this.iIndent + "  ";
    }

    protected String getScriptArg(String pToken) {
        return null;
    }

    protected String quote(String pString) {
        return null;
    }

    protected void writeOperation() {
        LinkedList<String> cmdArgs = this.getOperation().getCmdArgs();
        this.iLineBuffer = new StringBuilder();
        StringBuilder opBuffer = new StringBuilder();
        for (String token : cmdArgs) {
            char firstChar = token.charAt(0);
            if (firstChar == '-' || firstChar == '+') {
                this.flushBuffer(opBuffer);
                opBuffer = new StringBuilder(token);
                continue;
            }
            if (opBuffer.length() > 0) {
                opBuffer.append(" ");
            }
            if (token.startsWith("?img?")) {
                opBuffer.append(this.getScriptArg(token));
                continue;
            }
            if (firstChar == '(') {
                this.flushBuffer(opBuffer);
                this.flushLine(false);
                opBuffer = new StringBuilder("\"(\"");
                this.flushBuffer(opBuffer);
                this.flushLine(false);
                opBuffer = new StringBuilder();
                this.iIndent = this.iIndent + "  ";
                continue;
            }
            if (firstChar == ')') {
                this.flushBuffer(opBuffer);
                this.flushLine(false);
                this.iIndent = this.iIndent.substring(0, this.iIndent.length() - 2);
                opBuffer = new StringBuilder("\")\"");
                this.flushBuffer(opBuffer);
                this.flushLine(false);
                opBuffer = new StringBuilder();
                continue;
            }
            opBuffer.append(this.quote(token));
        }
        this.flushBuffer(opBuffer);
        this.flushLine(true);
    }

    private void flushBuffer(StringBuilder pBuf) {
        if (this.iIndent.length() + this.iLineBuffer.length() + pBuf.length() + 2 > 78) {
            this.flushLine(false);
            this.iLineBuffer.append((CharSequence)pBuf);
        } else {
            this.iLineBuffer.append((CharSequence)pBuf);
            this.iLineBuffer.append(" ");
        }
    }

    private void flushLine(boolean last) {
        PrintWriter writer = this.getWriter();
        writer.print(this.iIndent);
        writer.print(this.iLineBuffer.toString());
        if (last) {
            writer.println("\n");
        } else {
            writer.println(this.ESC_EOL);
            this.iLineBuffer = new StringBuilder();
        }
    }

    @Override
    public void init(PrintWriter pWriter, Operation pOp, Properties pProps) {
        this.iWriter = pWriter;
        this.iOp = pOp;
        this.iProps = pProps;
    }

    public PrintWriter getWriter() {
        return this.iWriter;
    }

    public Operation getOperation() {
        return this.iOp;
    }

    public Properties getProperties() {
        return this.iProps;
    }
}

