/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.core.ConvertCmd;
import com.github.geko444.im4java.core.DisplayCmd;
import com.github.geko444.im4java.core.IMOperation;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessTask;
import com.github.geko444.im4java.test.AbstractTestCase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestCase16a
extends AbstractTestCase {
    @Override
    public String getDescription() {
        return "asynchronous execution";
    }

    public static void main(String[] args) {
        TestCase16a tc = new TestCase16a();
        tc.runTest(args);
    }

    @Override
    public void run() throws Exception {
        System.err.println("16a. Testing asynchronous execution ...");
        IMOperation op = new IMOperation();
        op.size(400, 200);
        op.addImage("gradient:red", iTmpImage);
        ConvertCmd convert = new ConvertCmd();
        convert.run(op, new Object[0]);
        DisplayCmd display = new DisplayCmd();
        IMOperation dispOp = new IMOperation();
        dispOp.addImage(iTmpImage);
        ProcessTask pt = display.getProcessTask(dispOp, new Object[0]);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(pt);
        exec.shutdown();
        String waitType = "sleep";
        if (this.iArgs != null && this.iArgs.length > 0) {
            waitType = this.iArgs[0];
        }
        if (waitType.equals("sleep")) {
            this.waitSleep(exec, pt);
        } else if (waitType.equals("get")) {
            this.waitGet(pt);
        } else {
            this.waitWait(exec, pt);
        }
    }

    private void waitSleep(ExecutorService pExec, ProcessTask pPT) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            System.err.println("sleeping for one second...");
            Thread.sleep(1000L);
            if (pExec.isTerminated()) break;
        }
        if (!pExec.isTerminated()) {
            System.err.println("Trying to shutdown execution...");
            pPT.cancel(true);
            pExec.shutdownNow();
        } else {
            System.err.println("already terminated");
        }
        System.err.println("Terminated execution");
    }

    private void waitGet(ProcessTask pPT) throws Exception {
        try {
            System.err.println("waiting 10 seconds for process to finish with get ...");
            ProcessEvent pe = (ProcessEvent)pPT.get(10L, TimeUnit.SECONDS);
            System.err.println("process ended with " + pe.getReturnCode());
        }
        catch (TimeoutException toe) {
            System.err.println("canceling process ...");
            pPT.cancel(true);
            System.err.println("process terminated");
        }
    }

    private void waitWait(ExecutorService pExec, ProcessTask pPT) throws Exception {
        System.err.println("waiting 10 seconds for process to finish with awaitTermination ...");
        if (pExec.awaitTermination(10L, TimeUnit.SECONDS)) {
            System.err.println("process ended with " + ((ProcessEvent)pPT.get()).getReturnCode());
        } else {
            System.err.println("Trying to shutdown execution...");
            pPT.cancel(true);
            pExec.shutdownNow();
            System.err.println("process terminated");
        }
    }
}

