/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.core.ConvertCmd;
import com.github.geko444.im4java.core.IMOperation;
import com.github.geko444.im4java.core.ImageCommand;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessEventListener;
import com.github.geko444.im4java.process.ProcessExecutor;
import com.github.geko444.im4java.process.ProcessStarter;
import com.github.geko444.im4java.process.ProcessTask;
import com.github.geko444.im4java.test.AbstractTestCase;
import com.github.geko444.im4java.utils.ExtensionFilter;
import com.github.geko444.im4java.utils.FilenameLoader;
import com.github.geko444.im4java.utils.FilenamePatternResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TestCase21
extends AbstractTestCase
implements ProcessEventListener {
    protected IMOperation iOp = new IMOperation();
    private List<String> iImages;

    public TestCase21() {
        this.iOp.size(80);
        this.iOp.addImage();
        this.iOp.thumbnail(80);
        this.iOp.addImage();
    }

    @Override
    public String getDescription() {
        return "parallel processes";
    }

    public static void main(String[] args) {
        TestCase21 tc = new TestCase21();
        tc.runTest(args);
    }

    protected List<String> load() {
        String dir = iImageDir;
        boolean recMode = false;
        if (this.iArgs != null && this.iArgs.length > 0) {
            dir = this.iArgs[0];
        }
        if (this.iArgs != null && this.iArgs.length > 1) {
            recMode = Boolean.parseBoolean(this.iArgs[1]);
        }
        ExtensionFilter filter = new ExtensionFilter("jpg", "sh", "cmd");
        filter.setRecursion(recMode);
        filter.ignoreDotDirs(true);
        FilenameLoader loader = new FilenameLoader(filter);
        return loader.loadFilenames(dir);
    }

    @Override
    public void run() throws Exception {
        System.err.println("21. Testing parallel processes ...");
        this.iImages = this.load();
        String targetDir = iImageDir + ".thumbnails" + File.separatorChar;
        new File(targetDir).mkdir();
        FilenamePatternResolver fpr = new FilenamePatternResolver(targetDir + "%F");
        ProcessExecutor exec = new ProcessExecutor();
        ProcessStarter.setPIDCounter(0);
        for (String img : this.iImages) {
            System.out.println("processing " + img);
            ConvertCmd cmd = new ConvertCmd();
            cmd.addProcessEventListener(this);
            ProcessTask pt = cmd.getProcessTask(this.iOp, img, fpr.createName(img));
            exec.execute(pt);
        }
        exec.shutdown();
    }

    @Override
    public void processInitiated(ProcessEvent pEvent) {
    }

    @Override
    public void processStarted(ProcessEvent pEvent) {
    }

    @Override
    public void processTerminated(ProcessEvent pEvent) {
        if (pEvent.getReturnCode() != 0) {
            System.err.println("conversion failed for " + this.iImages.get(pEvent.getPID()));
            ImageCommand cmd = (ImageCommand)pEvent.getProcessStarter();
            ArrayList<String> errors = cmd.getErrorText();
            if (errors != null && errors.size() > 0) {
                System.err.println("  printing errors:");
                for (String err : errors) {
                    System.err.println("  " + err);
                }
            }
        } else {
            System.err.println("conversion successful for " + this.iImages.get(pEvent.getPID()));
        }
    }
}

