/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.test.TestCase21;
import com.github.geko444.im4java.utils.BatchConverter;
import java.io.File;
import java.util.List;

public class TestCase22
extends TestCase21 {
    @Override
    public String getDescription() {
        return "batch conversion";
    }

    public static void main(String[] args) {
        TestCase22 tc = new TestCase22();
        tc.runTest(args);
    }

    @Override
    public void run() throws Exception {
        System.err.println("22. Testing batch conversion  ...");
        BatchConverter.Mode runMode = BatchConverter.Mode.SEQUENTIAL;
        if (this.iArgs != null && this.iArgs.length > 2) {
            if (this.iArgs[2].equals("par")) {
                runMode = BatchConverter.Mode.PARALLEL;
            } else if (this.iArgs[2].equals("batch")) {
                runMode = BatchConverter.Mode.BATCH;
            }
        }
        List<String> images = this.load();
        String targetDir = iImageDir + ".thumbnails22" + File.separatorChar;
        new File(targetDir).mkdir();
        MyBatchConverter bc = new MyBatchConverter(runMode, images);
        bc.run(this.iOp, images, targetDir + "%F");
    }

    class MyBatchConverter
    extends BatchConverter {
        private long iStartTime;
        private List<String> iImages;

        MyBatchConverter(BatchConverter.Mode pMode, List<String> pImages) {
            super(pMode);
            this.iImages = pImages;
            this.iStartTime = System.nanoTime();
        }

        @Override
        public void terminated() {
            double elapsedTime = (double)(System.nanoTime() - this.iStartTime) / 1.0E9;
            System.err.println("Estimated elapsed time: " + elapsedTime);
            System.err.println("conversion terminated\n");
            List<BatchConverter.ConvertException> failed = this.getFailedConversions();
            if (failed != null && failed.size() > 0) {
                System.err.println("Failed images:");
                for (BatchConverter.ConvertException ex : failed) {
                    System.err.println("  " + this.iImages.get(ex.getIndex()));
                    Throwable cause = ex.getCause();
                    if (cause == null || cause.getMessage() == null) continue;
                    System.err.println(" " + cause.getMessage());
                }
            }
        }
    }
}

