/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.core.Info;
import com.github.geko444.im4java.core.InfoException;
import com.github.geko444.im4java.test.AbstractTestCase;
import java.util.Enumeration;

public class TestCase8
extends AbstractTestCase {
    @Override
    public String getDescription() {
        return "info";
    }

    public static void main(String[] args) {
        TestCase8 tc = new TestCase8();
        tc.runTest(args);
    }

    @Override
    public void run() throws Exception {
        System.err.println(" 8. Testing info ...");
        String imgName = iImageDir + "multi-scene.gif";
        if (this.iArgs != null && this.iArgs.length > 0) {
            imgName = this.iArgs[0];
        }
        boolean onlyBasic = false;
        if (this.iArgs != null && this.iArgs.length > 1) {
            onlyBasic = Boolean.parseBoolean(this.iArgs[1]);
        }
        if (!onlyBasic) {
            this.showCompleteInfo(imgName);
            if (imgName.equals("-") || imgName.endsWith(":-")) {
                return;
            }
        }
        this.showBasicInfo(imgName);
    }

    private void showCompleteInfo(String pImgName) throws InfoException {
        Info imageInfo = pImgName.equals("-") || pImgName.endsWith(":-") ? new Info(pImgName, System.in) : new Info(pImgName);
        Enumeration<String> props = imageInfo.getPropertyNames();
        if (props == null) {
            return;
        }
        System.out.println("\n==================================");
        System.out.println("complete info (all attributes)");
        System.out.println("==================================\n");
        while (props.hasMoreElements()) {
            String prop = props.nextElement();
            System.out.println(prop + "=" + imageInfo.getProperty(prop));
        }
        System.out.println("\n==================================");
        System.out.println("some attributes for every scene");
        System.out.println("==================================\n");
        int n = imageInfo.getSceneCount();
        for (int i = 0; i < n; ++i) {
            System.out.println(i + ": geometry=" + imageInfo.getProperty("Geometry", i));
            System.out.println(i + ": page geometry=" + imageInfo.getProperty("Page geometry", i));
        }
        System.out.println("\n==================================");
        System.out.println("basic information from complete info");
        System.out.println("==================================\n");
        this.dumpBasicInfo(imageInfo);
    }

    private void showBasicInfo(String pImgName) throws InfoException {
        System.out.println("\n=================");
        System.out.println("basic information");
        System.out.println("=================\n");
        Info imageInfo = pImgName.equals("-") || pImgName.endsWith(":-") ? new Info(pImgName, System.in, true) : new Info(pImgName, true);
        this.dumpBasicInfo(imageInfo);
    }

    private void dumpBasicInfo(Info pImageInfo) throws InfoException {
        System.out.println("Format: " + pImageInfo.getImageFormat());
        System.out.println("Width: " + pImageInfo.getImageWidth());
        System.out.println("Height: " + pImageInfo.getImageHeight());
        System.out.println("Geometry: " + pImageInfo.getImageGeometry());
        System.out.println("PageWidth: " + pImageInfo.getPageWidth());
        System.out.println("PageHeight: " + pImageInfo.getPageHeight());
        System.out.println("PageGeometry: " + pImageInfo.getPageGeometry());
        System.out.println("Depth: " + pImageInfo.getImageDepth());
        System.out.println("Class: " + pImageInfo.getImageClass());
        int n = pImageInfo.getSceneCount();
        for (int i = 0; i < n; ++i) {
            System.out.println("--------------- " + i + " -------------------");
            System.out.println("Format: " + pImageInfo.getImageFormat(i));
            System.out.println("Width: " + pImageInfo.getImageWidth(i));
            System.out.println("Height: " + pImageInfo.getImageHeight(i));
            System.out.println("Geometry: " + pImageInfo.getImageGeometry(i));
            System.out.println("PageWidth: " + pImageInfo.getPageWidth(i));
            System.out.println("PageHeight: " + pImageInfo.getPageHeight(i));
            System.out.println("PageGeometry: " + pImageInfo.getPageGeometry(i));
            System.out.println("Depth: " + pImageInfo.getImageDepth(i));
            System.out.println("Class: " + pImageInfo.getImageClass(i));
        }
    }
}

