/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.utils;

import com.github.geko444.im4java.core.CommandException;
import com.github.geko444.im4java.core.ConvertCmd;
import com.github.geko444.im4java.core.IM4JavaException;
import com.github.geko444.im4java.core.Operation;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessExecutor;
import com.github.geko444.im4java.process.ProcessTask;
import com.github.geko444.im4java.utils.FilenamePatternResolver;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class BatchConverter
extends ProcessExecutor {
    private Mode iMode = null;
    private List<ConvertException> iExceptions = null;

    public BatchConverter(Mode pMode) {
        this.iMode = pMode;
    }

    public void run(Operation pOp, List<String> pImages, String pTargetPattern) throws Exception, IOException, InterruptedException, IM4JavaException {
        if (pImages.isEmpty()) {
            return;
        }
        this.iExceptions = new LinkedList<ConvertException>();
        try {
            switch (this.iMode) {
                case SEQUENTIAL: {
                    this.runSeq(pOp, pImages, pTargetPattern);
                    break;
                }
                case PARALLEL: {
                    this.runPar(pOp, pImages, pTargetPattern);
                    break;
                }
                case BATCH: {
                    this.runBatch(pOp, pImages, pTargetPattern);
                }
            }
            this.shutdown();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSeq(Operation pOp, List<String> pImages, String pTargetPattern) throws IOException, InterruptedException, IM4JavaException {
        ConvertCmd cmd = new ConvertCmd();
        FilenamePatternResolver fpr = new FilenamePatternResolver(pTargetPattern);
        int i = 0;
        for (String img : pImages) {
            try {
                cmd.run(pOp, img, fpr.createName(img));
            }
            catch (Exception e) {
                this.addException(i, e);
            }
            finally {
                ++i;
            }
        }
    }

    private void runPar(Operation pOp, List<String> pImages, String pTargetPattern) throws IOException, InterruptedException, IM4JavaException {
        FilenamePatternResolver fpr = new FilenamePatternResolver(pTargetPattern);
        int i = 0;
        for (String img : pImages) {
            ConvertCmd cmd = new ConvertCmd();
            cmd.setPID(i++);
            ProcessTask pt = cmd.getProcessTask(pOp, img, fpr.createName(img));
            this.execute(pt);
        }
    }

    @Override
    public void processTerminated(ProcessEvent pEvent) {
        if (pEvent.getReturnCode() != 0) {
            this.addException(pEvent.getPID(), pEvent.getException());
        }
        super.processTerminated(pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatch(Operation pOp, List<String> pImages, String pTargetPattern) throws IOException, InterruptedException, IM4JavaException {
        int i;
        FilenamePatternResolver fpr = new FilenamePatternResolver(pTargetPattern);
        File firstFile = new File(fpr.createName(pImages.get(0)));
        String path = fpr.getFullpath(firstFile);
        String ext = fpr.getExt(firstFile);
        String rand = String.format("%04d", new Random().nextInt(10000));
        String template = String.format("%s%cim4java_%s.%s", path, Character.valueOf(File.separatorChar), rand, ext);
        Operation op = new Operation();
        LinkedList<String> args = pOp.getCmdArgs();
        boolean copyDone = false;
        for (String arg : args) {
            if (!copyDone && arg.startsWith("?img?")) {
                for (i = 0; i < pImages.size(); ++i) {
                    op.addRawArgs(arg);
                }
                copyDone = true;
                continue;
            }
            op.addRawArgs(arg);
        }
        ConvertCmd cmd = new ConvertCmd();
        String[] images = new String[pImages.size() + 1];
        images = pImages.toArray(images);
        images[pImages.size()] = template;
        try {
            cmd.run(op, images);
        }
        catch (CommandException ce) {
            String prefix = path + File.separatorChar + "im4java_" + rand + "-";
            String suffix = "." + ext;
            for (int i2 = 0; i2 < pImages.size(); ++i2) {
                File src = new File(prefix + i2 + suffix);
                src.delete();
            }
            this.addException(0, ce);
            return;
        }
        i = 0;
        String prefix = path + File.separatorChar + "im4java_" + rand + "-";
        String suffix = "." + ext;
        for (String img : pImages) {
            try {
                File src = new File(prefix + i + suffix);
                File dest = new File(fpr.createName(img));
                dest.delete();
                if (src.renameTo(dest)) continue;
                this.addException(0, new Exception("rename failed"));
            }
            catch (Exception e) {
                this.addException(0, e);
                return;
            }
            finally {
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addException(int pIndex, Exception pException) {
        List<ConvertException> list = this.iExceptions;
        synchronized (list) {
            this.iExceptions.add(new ConvertException(pIndex, pException));
        }
    }

    public List<ConvertException> getFailedConversions() {
        return this.iExceptions;
    }

    public Mode getMode() {
        return this.iMode;
    }

    public class ConvertException
    extends Exception {
        private int iIndex;

        public ConvertException(int pIndex, Exception pCause) {
            super(pCause);
            this.fillInStackTrace();
            this.iIndex = pIndex;
        }

        public int getIndex() {
            return this.iIndex;
        }
    }

    public static enum Mode {
        SEQUENTIAL,
        PARALLEL,
        BATCH;

    }
}

