/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sharpen.core.DocumentationOverlay;
import sharpen.core.MemberKind;
import sharpen.core.NamingStrategy;
import sharpen.core.NullDocumentationOverlay;
import sharpen.core.WarningHandler;

public abstract class Configuration {
    private static final WarningHandler NULL_WARNING_HANDLER = new WarningHandler();
    private Map<String, String> _typeMappings = new HashMap<String, String>();
    private Map<String, MemberMapping> _memberMappings = new HashMap<String, MemberMapping>();
    private Map<String, String> _systemConvertWellKnownTypes = new HashMap<String, String>();
    private List<NameMapping> _namespaceMappings = new ArrayList<NameMapping>();
    private WarningHandler _warningHandler = NULL_WARNING_HANDLER;
    private NamingStrategy _namingStrategy = NamingStrategy.DEFAULT;
    private String _indentString;
    private int _maxColumns = 80;
    private boolean _nativeTypeSystem = false;
    private boolean _ignoreErrors = false;
    private final String _runtimeTypeName;
    private boolean _nativeInterfaces;
    private boolean _separateInterfaceConstants;
    private boolean _organizeUsings;
    private boolean _paramCountFileNames;
    private boolean _junitConvert;
    private List<String> _fullyQualifiedTypes = new ArrayList<String>();
    private boolean _createProblemMarkers = false;
    private String _header = "";
    private DocumentationOverlay _docOverlay = NullDocumentationOverlay.DEFAULT;
    private final List<String> _removedMethods = new ArrayList<String>();
    private final Set<String> _mappedEventAdds = new HashSet<String>();
    private final Map<String, String> _mappedEvents = new HashMap<String, String>();
    private List<String> _partialTypes = new ArrayList<String>();
    private Map<String, String> _conditionalCompilations = new HashMap<String, String>();

    public Configuration(String runtimeTypeName) {
        this._runtimeTypeName = runtimeTypeName;
    }

    protected void setUpAnnotationMappings() {
        this.mapType("java.lang.Deprecated", "System.Obsolete");
    }

    protected void setUpStringMappings() {
        this.mapType("java.lang.StringBuffer", "System.Text.StringBuilder");
        this.mapProperty("java.lang.StringBuffer.length", "Length");
        this.mapMethod("java.lang.StringBuffer.append", "Append");
        this.mapMethod("java.lang.StringBuffer.insert", "Insert");
        this.mapMethod("java.lang.Appendable.append", "Append");
        this.mapMethod("java.lang.AbstractStringBuilder.append", "Append");
        this.mapMethod("java.lang.AbstractStringBuilder.insert", "Insert");
        this.mapMethod("java.lang.StringBuffer.deleteCharAt", this.runtimeMethod("deleteCharAt"));
        this.mapMethod("java.lang.AbstractStringBuilder.deleteCharAt", this.runtimeMethod("deleteCharAt"));
        this.mapMethod("java.lang.StringBuffer.setCharAt", this.runtimeMethod("setCharAt"));
        this.mapMethod("java.lang.AbstractStringBuilder.setCharAt", this.runtimeMethod("setCharAt"));
        this.mapProperty("java.lang.StringBuffer.setLength", "Length");
        this.mapProperty("java.lang.AbstractStringBuilder.setLength", "Length");
        this.mapMethod("java.lang.String.intern", "string.Intern");
        this.mapMethod("java.lang.String.indexOf", "IndexOf");
        this.mapMethod("java.lang.String.lastIndexOf", "LastIndexOf");
        this.mapMethod("java.lang.String.trim", "Trim");
        this.mapMethod("java.lang.String.toUpperCase", "ToUpper");
        this.mapMethod("java.lang.String.toLowerCase", "ToLower");
        this.mapMethod("java.lang.String.compareTo", "CompareTo");
        this.mapMethod("java.lang.Comparable.compareTo(java.lang.String)", "string.CompareOrdinal");
        this.mapMethod("java.lang.String.toCharArray", "ToCharArray");
        this.mapMethod("java.lang.String.replace", "Replace");
        this.mapMethod("java.lang.String.startsWith", "StartsWith");
        this.mapMethod("java.lang.String.endsWith", "EndsWith");
        this.mapMethod("java.lang.String.substring", this.runtimeMethod("substring"));
        this.mapIndexer("java.lang.String.charAt");
        this.mapIndexer("java.lang.CharSequence.charAt");
        this.mapMethod("java.lang.String.getChars", this.runtimeMethod("getCharsForString"));
        this.mapMethod("java.lang.String.getBytes", this.runtimeMethod("getBytesForString"));
        this.mapMethod("java.lang.String.equalsIgnoreCase", this.runtimeMethod("equalsIgnoreCase"));
        this.mapMethod("java.lang.String.valueOf", this.runtimeMethod("getStringValueOf"));
        this.mapMethod("java.lang.String.String(byte[])", this.runtimeMethod("getStringForBytes"));
        this.mapMethod("java.lang.String.String(byte[],int,int)", this.runtimeMethod("getStringForBytes"));
        this.mapMethod("java.lang.String.String(byte[],int,int,java.lang.String)", this.runtimeMethod("getStringForBytes"));
        this.mapMethod("java.lang.String.String(byte[],java.lang.String)", this.runtimeMethod("getStringForBytes"));
        this.mapProperty("java.lang.String.length", "Length");
        this.mapProperty("java.lang.CharSequence.length", "Length");
    }

    protected void setUpIoMappings() {
        this.mapProperty("java.lang.System.out", "System.Console.Out");
        this.mapProperty("java.lang.System.err", "System.Console.Error");
        this.mapType("java.io.PrintStream", "System.IO.TextWriter");
        this.mapType("java.io.Writer", "System.IO.TextWriter");
        this.mapMethod("java.io.Writer.flush", "Flush");
        this.mapType("java.io.StringWriter", "System.IO.StringWriter");
        this.mapMethod("java.io.PrintStream.print", "Write");
        this.mapMethod("java.io.PrintStream.println", "WriteLine");
    }

    protected String collectionRuntimeMethod(String methodName) {
        return this.collectionRuntimeType() + "." + methodName;
    }

    private String collectionRuntimeType() {
        return this.runtimeTypeNamespace() + ".Collections";
    }

    private String runtimeTypeNamespace() {
        return this._runtimeTypeName.substring(0, this._runtimeTypeName.lastIndexOf(46));
    }

    protected String runtimeMethod(String methodName) {
        return this._runtimeTypeName + "." + methodName;
    }

    protected void mapPrimitive(String typeName) {
        this.mapType(typeName, typeName);
    }

    public String getRuntimeTypeName() {
        return this._runtimeTypeName;
    }

    public void setDocumentationOverlay(DocumentationOverlay docOverlay) {
        if (null == docOverlay) {
            throw new IllegalArgumentException("docOverlay");
        }
        this._docOverlay = docOverlay;
    }

    public DocumentationOverlay documentationOverlay() {
        return this._docOverlay;
    }

    public String getIndentString() {
        return this._indentString;
    }

    public void setIndentString(String indentString) {
        this._indentString = indentString;
    }

    public int getMaxColumns() {
        return this._maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        this._maxColumns = maxColumns;
    }

    public void enableNativeTypeSystem() {
        this._nativeTypeSystem = true;
        this.mapType("java.lang.ClassNotFoundException", "System.TypeLoadException");
        this.mapType("java.lang.reflect.InvocationTargetException", "System.Reflection.TargetInvocationException");
        this.mapProperty("java.lang.reflect.InvocationTargetException.getTargetException", "InnerException");
        this.mapType("java.lang.IllegalAccessException", "System.MemberAccessException");
        this.mapMethod("java.lang.reflect.Array.getLength", this.runtimeMethod("GetArrayLength"));
        this.mapMethod("java.lang.reflect.Array.get", this.runtimeMethod("GetArrayValue"));
        this.mapMethod("java.lang.reflect.Array.set", this.runtimeMethod("SetArrayValue"));
        this.mapMethod("java.lang.reflect.Array.newInstance", "System.Array.CreateInstance");
        this.mapMethod("java.lang.Object.getClass", "GetType");
        this.mapType("java.lang.Class", "System.Type");
        this.mapType("java.lang.Class<>", "System.Type");
        this.mapJavaLangClassProperty("getName", "FullName");
        this.mapJavaLangClassProperty("getSuperclass", "BaseType");
        this.mapJavaLangClassProperty("isArray", "IsArray");
        this.mapJavaLangClassProperty("isPrimitive", "IsPrimitive");
        this.mapJavaLangClassProperty("isInterface", "IsInterface");
        this.mapJavaLangClassMethod("isInstance", "IsInstanceOfType");
        this.mapJavaLangClassMethod("newInstance", "System.Activator.CreateInstance");
        this.mapJavaLangClassMethod("forName", this.runtimeMethod("GetType"));
        this.mapJavaLangClassMethod("getComponentType", "GetElementType");
        this.mapJavaLangClassMethod("getField", "GetField");
        this.mapJavaLangClassMethod("getFields", "GetFields");
        this.mapJavaLangClassMethod("getDeclaredField", this.runtimeMethod("GetDeclaredField"));
        this.mapJavaLangClassMethod("getDeclaredFields", this.runtimeMethod("GetDeclaredFields"));
        this.mapJavaLangClassMethod("getDeclaredMethod", this.runtimeMethod("GetDeclaredMethod"));
        this.mapJavaLangClassMethod("getDeclaredMethods", this.runtimeMethod("GetDeclaredMethods"));
        this.mapJavaLangClassMethod("isAssignableFrom", "IsAssignableFrom");
        this.mapProperty("java.lang.reflect.Member.getName", "Name");
        this.mapProperty("java.lang.reflect.Member.getDeclaringClass", "DeclaringType");
        this.mapType("java.lang.reflect.Field", "System.Reflection.FieldInfo");
        this.mapProperty("java.lang.reflect.Field.getName", "Name");
        this.mapMethod("java.lang.reflect.Field.get", "GetValue");
        this.mapMethod("java.lang.reflect.Field.set", "SetValue");
        this.mapType("java.lang.reflect.Method", "System.Reflection.MethodInfo");
        this.mapProperty("java.lang.reflect.Method.getName", "Name");
        this.mapProperty("java.lang.reflect.Method.getReturnType", "ReturnType");
        this.mapMethod("java.lang.reflect.Method.getParameterTypes", this.runtimeMethod("GetParameterTypes"));
        this.removeMethod("java.lang.reflect.AccessibleObject.setAccessible");
        this.mapType("java.lang.reflect.Constructor", "System.Reflection.ConstructorInfo");
        this.mapMethod("java.lang.String.valueOf", "ToString");
    }

    private void mapJavaLangClassProperty(String methodName, String propertyName) {
        this.mapProperty("java.lang.Class." + methodName, propertyName);
    }

    private void mapJavaLangClassMethod(String methodName, String newMethodName) {
        this.mapMethod("java.lang.Class." + methodName, newMethodName);
    }

    public boolean nativeTypeSystem() {
        return this._nativeTypeSystem;
    }

    public void setWarningHandler(WarningHandler warningHandler) {
        this._warningHandler = warningHandler;
    }

    public WarningHandler getWarningHandler() {
        return this._warningHandler;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this._namingStrategy = namingStrategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this._namingStrategy;
    }

    public void mapNamespace(String fromRegex, String to) {
        this._namespaceMappings.add(new NameMapping(fromRegex, to));
    }

    public void mapNamespaces(List<NameMapping> namespaceMappings) {
        this._namespaceMappings.addAll(namespaceMappings);
    }

    public void mapMembers(Map<String, MemberMapping> memberMappings) {
        this._memberMappings.putAll(memberMappings);
    }

    public String mappedNamespace(String namespace) {
        String mapped = this.applyNamespaceMappings(namespace + ".");
        return this._namingStrategy.namespace(mapped.substring(0, mapped.length() - 1));
    }

    public String mappedTypeName(String typeName, String defaultValue) {
        String mappedName = this._typeMappings.get(typeName);
        return null != mappedName ? mappedName : this.mappedNamespace(defaultValue);
    }

    private String applyNamespaceMappings(String typeName) {
        for (NameMapping mapping : this._namespaceMappings) {
            typeName = typeName.replaceFirst(mapping.from + "\\.", mapping.to + ".");
        }
        return typeName;
    }

    public MemberMapping mappedMember(String qualifiedName) {
        return this._memberMappings.get(qualifiedName);
    }

    public String getConvertRelatedWellKnownTypeName(String mappedConstructor) {
        return this._systemConvertWellKnownTypes.get(mappedConstructor);
    }

    public void mapType(String from, String to) {
        this._typeMappings.put(from, to);
    }

    public boolean typeHasMapping(String type) {
        return this._typeMappings.containsKey(type);
    }

    public void mapField(String fromQualifiedName, String to) {
        this.mapMember(fromQualifiedName, new MemberMapping(to, MemberKind.Field));
    }

    public void mapMethod(String fromQualifiedName, String to) {
        this.mapMember(fromQualifiedName, new MemberMapping(to, MemberKind.Method));
    }

    public void mapIndexer(String fromQualifiedName) {
        this.mapMember(fromQualifiedName, new MemberMapping(null, MemberKind.Indexer));
    }

    public void mapProperty(String fromQualifiedName, String to) {
        this.mapMember(fromQualifiedName, new MemberMapping(to, MemberKind.Property));
    }

    public void setIgnoreErrors(boolean value) {
        this._ignoreErrors = value;
    }

    public boolean getIgnoreErrors() {
        return this._ignoreErrors;
    }

    void mapMember(String fromQualifiedName, MemberMapping mapping) {
        this._memberMappings.put(fromQualifiedName, mapping);
    }

    protected void mapWrapperConstructor(String from, String to, String wellKnownTypeName) {
        this.mapMethod(from, to);
        this._systemConvertWellKnownTypes.put(to, wellKnownTypeName);
    }

    public boolean nativeInterfaces() {
        return this._nativeInterfaces;
    }

    public void enableNativeInterfaces() {
        this._nativeInterfaces = true;
    }

    public boolean separateInterfaceConstants() {
        return this._separateInterfaceConstants;
    }

    public void enableSeparateInterfaceConstants() {
        this._separateInterfaceConstants = true;
    }

    public void enableOrganizeUsings() {
        this._organizeUsings = true;
    }

    public boolean organizeUsings() {
        return this._organizeUsings;
    }

    public void enableParamCountFileNames() {
        this._paramCountFileNames = true;
    }

    public boolean paramCountFileNames() {
        return this._paramCountFileNames;
    }

    public void enableJUnitConversion() {
        this._junitConvert = true;
    }

    public boolean junitConversion() {
        return this._junitConvert;
    }

    public void addFullyQualifiedTypeName(String name) {
        this._fullyQualifiedTypes.add(name);
    }

    public void addPartialType(String name) {
        this._partialTypes.add(name);
    }

    public boolean shouldFullyQualifyTypeName(String name) {
        for (String s : this._fullyQualifiedTypes) {
            if (!name.equals(s) && !name.startsWith(s + ".")) continue;
            return true;
        }
        return false;
    }

    public boolean shouldMakePartial(String name) {
        for (String s : this._partialTypes) {
            if (!name.equals(s) && !name.startsWith(s + ".")) continue;
            return true;
        }
        return false;
    }

    public void setCreateProblemMarkers(boolean value) {
        this._createProblemMarkers = value;
    }

    public boolean createProblemMarkers() {
        return this._createProblemMarkers;
    }

    public void setHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("header");
        }
        this._header = header;
    }

    public String header() {
        return this._header;
    }

    public void removeMethod(String fullyQualifiedName) {
        this._removedMethods.add(fullyQualifiedName);
    }

    public boolean isRemoved(String qualifiedName) {
        return this._removedMethods.contains(qualifiedName);
    }

    public void mapEventAdd(String qualifiedMethodName) {
        this._mappedEventAdds.add(qualifiedMethodName);
    }

    public boolean isMappedEventAdd(String qualifiedMethodName) {
        return this._mappedEventAdds.contains(qualifiedMethodName);
    }

    public void mapEvent(String qualifiedMethodName, String eventArgsTypeName) {
        this.mapProperty(qualifiedMethodName, this.unqualify(qualifiedMethodName));
        this._mappedEvents.put(qualifiedMethodName, eventArgsTypeName);
    }

    public String mappedEvent(String qualifiedMethodName) {
        return this._mappedEvents.get(qualifiedMethodName);
    }

    private String unqualify(String qualifiedMethodName) {
        int lastDot = qualifiedMethodName.lastIndexOf(46);
        return lastDot == -1 ? qualifiedMethodName : qualifiedMethodName.substring(lastDot + 1);
    }

    public void mapEventAdds(Iterable<String> eventAddMappings) {
        for (String m : eventAddMappings) {
            this.mapEventAdd(m);
        }
    }

    public void mapEvents(Iterable<NameMapping> eventMappings) {
        for (NameMapping m : eventMappings) {
            this.mapEvent(m.from, m.to);
        }
    }

    public boolean isIgnoredAnnotation(String typeName) {
        return typeName.equals("java.lang.Override");
    }

    public void conditionalCompilation(Map<String, String> conditionalCompilation) {
        this._conditionalCompilations = conditionalCompilation;
    }

    public String conditionalCompilationExpressionFor(String packageName) {
        for (String current : this._conditionalCompilations.keySet()) {
            if (!this.isSubPackage(current, packageName)) continue;
            return this._conditionalCompilations.get(current);
        }
        return null;
    }

    private boolean isSubPackage(String parentPackage, String packageName) {
        return packageName.startsWith(parentPackage);
    }

    public String toInterfaceName(String name) {
        if (!this.nativeInterfaces()) {
            return name;
        }
        return "I" + name;
    }

    public abstract boolean isIgnoredExceptionType(String var1);

    public boolean mapProtectedToProtectedInternal() {
        return true;
    }

    public boolean mapIteratorToEnumerator() {
        return true;
    }

    public abstract boolean mapByteToSbyte();

    public static class NameMapping {
        public String from;
        public String to;

        public NameMapping(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NameMapping)) {
                return false;
            }
            NameMapping other = (NameMapping)obj;
            return this.from.equals(other.from) && this.to.equals(other.to);
        }
    }

    public static class MemberMapping {
        public String name;
        public MemberKind kind;

        public MemberMapping(String name, MemberKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public String toString() {
            return "MemberMapping(" + this.name + ", " + (Object)((Object)this.kind) + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberMapping)) {
                return false;
            }
            MemberMapping other = (MemberMapping)obj;
            return this.name.equals(other.name) && this.kind.equals((Object)other.kind);
        }
    }
}

