/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSBlock;
import sharpen.core.csharp.ast.CSMetaMember;
import sharpen.core.csharp.ast.CSParameterized;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSVariableDeclaration;
import sharpen.core.csharp.ast.CSVisitor;

public class CSProperty
extends CSMetaMember
implements CSParameterized {
    public static final String INDEXER = "this";
    private List<CSVariableDeclaration> _parameters;
    private CSBlock _getter;
    private CSBlock _setter;

    public CSProperty(String name, CSTypeReferenceExpression type) {
        super(name, type);
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addParameter(CSVariableDeclaration parameter) {
        if (null == this._parameters) {
            this._parameters = new ArrayList<CSVariableDeclaration>();
        }
        this._parameters.add(parameter);
    }

    public List<CSVariableDeclaration> parameters() {
        if (null == this._parameters) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._parameters);
    }

    public void getter(CSBlock getter) {
        this._getter = getter;
    }

    public CSBlock getter() {
        return this._getter;
    }

    public void setter(CSBlock block) {
        this._setter = block;
    }

    public CSBlock setter() {
        return this._setter;
    }

    public boolean isIndexer() {
        return INDEXER.equals(this.name());
    }
}

