/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.dynamodb;

import io.aws.lambda.events.dynamodb.AttributeValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StreamRecord
implements Serializable {
    private long approximateCreationDateTime;
    private Map<String, AttributeValue> keys;
    private Map<String, AttributeValue> newImage;
    private Map<String, AttributeValue> oldImage;
    private String sequenceNumber;
    private Long sizeBytes;
    private StreamViewType streamViewType;

    public StreamRecord addKeysEntry(String key, AttributeValue value) {
        if (null == this.keys) {
            this.keys = new HashMap<String, AttributeValue>();
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.keys.put(key, value);
        return this;
    }

    public StreamRecord clearKeysEntries() {
        this.keys = null;
        return this;
    }

    public StreamRecord addNewImageEntry(String key, AttributeValue value) {
        if (null == this.newImage) {
            this.newImage = new HashMap<String, AttributeValue>();
        }
        if (this.newImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.newImage.put(key, value);
        return this;
    }

    public StreamRecord clearNewImageEntries() {
        this.newImage = null;
        return this;
    }

    public StreamRecord addOldImageEntry(String key, AttributeValue value) {
        if (null == this.oldImage) {
            this.oldImage = new HashMap<String, AttributeValue>();
        }
        if (this.oldImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.oldImage.put(key, value);
        return this;
    }

    public StreamRecord clearOldImageEntries() {
        this.oldImage = null;
        return this;
    }

    @NotNull
    public Map<String, AttributeValue> getKeys() {
        return this.keys == null ? Collections.emptyMap() : this.keys;
    }

    @NotNull
    public Map<String, AttributeValue> getNewImage() {
        return this.newImage == null ? Collections.emptyMap() : this.newImage;
    }

    @NotNull
    public Map<String, AttributeValue> getOldImage() {
        return this.oldImage == null ? Collections.emptyMap() : this.oldImage;
    }

    public long getApproximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public StreamViewType getStreamViewType() {
        return this.streamViewType;
    }

    public StreamRecord setApproximateCreationDateTime(long approximateCreationDateTime) {
        this.approximateCreationDateTime = approximateCreationDateTime;
        return this;
    }

    public StreamRecord setKeys(Map<String, AttributeValue> keys) {
        this.keys = keys;
        return this;
    }

    public StreamRecord setNewImage(Map<String, AttributeValue> newImage) {
        this.newImage = newImage;
        return this;
    }

    public StreamRecord setOldImage(Map<String, AttributeValue> oldImage) {
        this.oldImage = oldImage;
        return this;
    }

    public StreamRecord setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    public StreamRecord setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    public StreamRecord setStreamViewType(StreamViewType streamViewType) {
        this.streamViewType = streamViewType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getApproximateCreationDateTime() != other.getApproximateCreationDateTime()) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Map<String, AttributeValue> this$keys = this.getKeys();
        Map<String, AttributeValue> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Map<String, AttributeValue> this$newImage = this.getNewImage();
        Map<String, AttributeValue> other$newImage = other.getNewImage();
        if (this$newImage == null ? other$newImage != null : !((Object)this$newImage).equals(other$newImage)) {
            return false;
        }
        Map<String, AttributeValue> this$oldImage = this.getOldImage();
        Map<String, AttributeValue> other$oldImage = other.getOldImage();
        if (this$oldImage == null ? other$oldImage != null : !((Object)this$oldImage).equals(other$oldImage)) {
            return false;
        }
        String this$sequenceNumber = this.getSequenceNumber();
        String other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !this$sequenceNumber.equals(other$sequenceNumber)) {
            return false;
        }
        StreamViewType this$streamViewType = this.getStreamViewType();
        StreamViewType other$streamViewType = other.getStreamViewType();
        return !(this$streamViewType == null ? other$streamViewType != null : !((Object)((Object)this$streamViewType)).equals((Object)other$streamViewType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $approximateCreationDateTime = this.getApproximateCreationDateTime();
        result = result * 59 + (int)($approximateCreationDateTime >>> 32 ^ $approximateCreationDateTime);
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Map<String, AttributeValue> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Map<String, AttributeValue> $newImage = this.getNewImage();
        result = result * 59 + ($newImage == null ? 43 : ((Object)$newImage).hashCode());
        Map<String, AttributeValue> $oldImage = this.getOldImage();
        result = result * 59 + ($oldImage == null ? 43 : ((Object)$oldImage).hashCode());
        String $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : $sequenceNumber.hashCode());
        StreamViewType $streamViewType = this.getStreamViewType();
        result = result * 59 + ($streamViewType == null ? 43 : ((Object)((Object)$streamViewType)).hashCode());
        return result;
    }

    public String toString() {
        return "StreamRecord(approximateCreationDateTime=" + this.getApproximateCreationDateTime() + ", keys=" + this.getKeys() + ", newImage=" + this.getNewImage() + ", oldImage=" + this.getOldImage() + ", sequenceNumber=" + this.getSequenceNumber() + ", sizeBytes=" + this.getSizeBytes() + ", streamViewType=" + this.getStreamViewType() + ")";
    }

    public static enum StreamViewType {
        NEW_IMAGE,
        OLD_IMAGE,
        NEW_AND_OLD_IMAGES,
        KEYS_ONLY;

    }
}

