/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.gateway;

import io.aws.lambda.events.BodyBase64Event;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class APIGatewayV2HTTPEvent
extends BodyBase64Event<APIGatewayV2HTTPEvent> {
    private String version;
    private String routeKey;
    private String rawPath;
    private String rawQueryString;
    private List<String> cookies;
    private Map<String, String> headers;
    private Map<String, String> queryStringParameters;
    private Map<String, String> pathParameters;
    private Map<String, String> stageVariables;
    private RequestContext requestContext;

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    @NotNull
    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters == null ? Collections.emptyMap() : this.queryStringParameters;
    }

    @NotNull
    public Map<String, String> getPathParameters() {
        return this.pathParameters == null ? Collections.emptyMap() : this.pathParameters;
    }

    @NotNull
    public Map<String, String> getStageVariables() {
        return this.stageVariables == null ? Collections.emptyMap() : this.stageVariables;
    }

    @NotNull
    public List<String> getCookies() {
        return this.cookies == null ? Collections.emptyList() : this.cookies;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getRawQueryString() {
        return this.rawQueryString;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public APIGatewayV2HTTPEvent setVersion(String version) {
        this.version = version;
        return this;
    }

    public APIGatewayV2HTTPEvent setRouteKey(String routeKey) {
        this.routeKey = routeKey;
        return this;
    }

    public APIGatewayV2HTTPEvent setRawPath(String rawPath) {
        this.rawPath = rawPath;
        return this;
    }

    public APIGatewayV2HTTPEvent setRawQueryString(String rawQueryString) {
        this.rawQueryString = rawQueryString;
        return this;
    }

    public APIGatewayV2HTTPEvent setCookies(List<String> cookies) {
        this.cookies = cookies;
        return this;
    }

    public APIGatewayV2HTTPEvent setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public APIGatewayV2HTTPEvent setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public APIGatewayV2HTTPEvent setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public APIGatewayV2HTTPEvent setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
        return this;
    }

    public APIGatewayV2HTTPEvent setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    @Override
    public String toString() {
        return "APIGatewayV2HTTPEvent(version=" + this.getVersion() + ", routeKey=" + this.getRouteKey() + ", rawPath=" + this.getRawPath() + ", rawQueryString=" + this.getRawQueryString() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", queryStringParameters=" + this.getQueryStringParameters() + ", pathParameters=" + this.getPathParameters() + ", stageVariables=" + this.getStageVariables() + ", requestContext=" + this.getRequestContext() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIGatewayV2HTTPEvent)) {
            return false;
        }
        APIGatewayV2HTTPEvent other = (APIGatewayV2HTTPEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$routeKey = this.getRouteKey();
        String other$routeKey = other.getRouteKey();
        if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
            return false;
        }
        String this$rawPath = this.getRawPath();
        String other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) {
            return false;
        }
        String this$rawQueryString = this.getRawQueryString();
        String other$rawQueryString = other.getRawQueryString();
        if (this$rawQueryString == null ? other$rawQueryString != null : !this$rawQueryString.equals(other$rawQueryString)) {
            return false;
        }
        List<String> this$cookies = this.getCookies();
        List<String> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryStringParameters = this.getQueryStringParameters();
        Map<String, String> other$queryStringParameters = other.getQueryStringParameters();
        if (this$queryStringParameters == null ? other$queryStringParameters != null : !((Object)this$queryStringParameters).equals(other$queryStringParameters)) {
            return false;
        }
        Map<String, String> this$pathParameters = this.getPathParameters();
        Map<String, String> other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters)) {
            return false;
        }
        Map<String, String> this$stageVariables = this.getStageVariables();
        Map<String, String> other$stageVariables = other.getStageVariables();
        if (this$stageVariables == null ? other$stageVariables != null : !((Object)this$stageVariables).equals(other$stageVariables)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        return !(this$requestContext == null ? other$requestContext != null : !((Object)this$requestContext).equals(other$requestContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIGatewayV2HTTPEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $routeKey = this.getRouteKey();
        result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
        String $rawPath = this.getRawPath();
        result = result * 59 + ($rawPath == null ? 43 : $rawPath.hashCode());
        String $rawQueryString = this.getRawQueryString();
        result = result * 59 + ($rawQueryString == null ? 43 : $rawQueryString.hashCode());
        List<String> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryStringParameters = this.getQueryStringParameters();
        result = result * 59 + ($queryStringParameters == null ? 43 : ((Object)$queryStringParameters).hashCode());
        Map<String, String> $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        Map<String, String> $stageVariables = this.getStageVariables();
        result = result * 59 + ($stageVariables == null ? 43 : ((Object)$stageVariables).hashCode());
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : ((Object)$requestContext).hashCode());
        return result;
    }

    public static class RequestContext {
        private String routeKey;
        private String accountId;
        private String stage;
        private String apiId;
        private String domainName;
        private String domainPrefix;
        private String time;
        private long timeEpoch;
        private Http http;
        private Authorizer authorizer;
        private String requestId;

        public String getRouteKey() {
            return this.routeKey;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getStage() {
            return this.stage;
        }

        public String getApiId() {
            return this.apiId;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getDomainPrefix() {
            return this.domainPrefix;
        }

        public String getTime() {
            return this.time;
        }

        public long getTimeEpoch() {
            return this.timeEpoch;
        }

        public Http getHttp() {
            return this.http;
        }

        public Authorizer getAuthorizer() {
            return this.authorizer;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public RequestContext setRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public RequestContext setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public RequestContext setStage(String stage) {
            this.stage = stage;
            return this;
        }

        public RequestContext setApiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public RequestContext setDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public RequestContext setDomainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        public RequestContext setTime(String time) {
            this.time = time;
            return this;
        }

        public RequestContext setTimeEpoch(long timeEpoch) {
            this.timeEpoch = timeEpoch;
            return this;
        }

        public RequestContext setHttp(Http http) {
            this.http = http;
            return this;
        }

        public RequestContext setAuthorizer(Authorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public RequestContext setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeEpoch() != other.getTimeEpoch()) {
                return false;
            }
            String this$routeKey = this.getRouteKey();
            String other$routeKey = other.getRouteKey();
            if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$stage = this.getStage();
            String other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
                return false;
            }
            String this$apiId = this.getApiId();
            String other$apiId = other.getApiId();
            if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
                return false;
            }
            String this$domainName = this.getDomainName();
            String other$domainName = other.getDomainName();
            if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
                return false;
            }
            String this$domainPrefix = this.getDomainPrefix();
            String other$domainPrefix = other.getDomainPrefix();
            if (this$domainPrefix == null ? other$domainPrefix != null : !this$domainPrefix.equals(other$domainPrefix)) {
                return false;
            }
            String this$time = this.getTime();
            String other$time = other.getTime();
            if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
                return false;
            }
            Http this$http = this.getHttp();
            Http other$http = other.getHttp();
            if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
                return false;
            }
            Authorizer this$authorizer = this.getAuthorizer();
            Authorizer other$authorizer = other.getAuthorizer();
            if (this$authorizer == null ? other$authorizer != null : !((Object)this$authorizer).equals(other$authorizer)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeEpoch = this.getTimeEpoch();
            result = result * 59 + (int)($timeEpoch >>> 32 ^ $timeEpoch);
            String $routeKey = this.getRouteKey();
            result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $stage = this.getStage();
            result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
            String $apiId = this.getApiId();
            result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
            String $domainName = this.getDomainName();
            result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
            String $domainPrefix = this.getDomainPrefix();
            result = result * 59 + ($domainPrefix == null ? 43 : $domainPrefix.hashCode());
            String $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : $time.hashCode());
            Http $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            Authorizer $authorizer = this.getAuthorizer();
            result = result * 59 + ($authorizer == null ? 43 : ((Object)$authorizer).hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            return result;
        }

        public String toString() {
            return "APIGatewayV2HTTPEvent.RequestContext(routeKey=" + this.getRouteKey() + ", accountId=" + this.getAccountId() + ", stage=" + this.getStage() + ", apiId=" + this.getApiId() + ", domainName=" + this.getDomainName() + ", domainPrefix=" + this.getDomainPrefix() + ", time=" + this.getTime() + ", timeEpoch=" + this.getTimeEpoch() + ", http=" + this.getHttp() + ", authorizer=" + this.getAuthorizer() + ", requestId=" + this.getRequestId() + ")";
        }

        public static class CognitoIdentity {
            private List<String> amr;
            private String identityId;
            private String identityPoolId;

            @NotNull
            public List<String> getAmr() {
                return this.amr == null ? Collections.emptyList() : this.amr;
            }

            public String getIdentityId() {
                return this.identityId;
            }

            public String getIdentityPoolId() {
                return this.identityPoolId;
            }

            public CognitoIdentity setAmr(List<String> amr) {
                this.amr = amr;
                return this;
            }

            public CognitoIdentity setIdentityId(String identityId) {
                this.identityId = identityId;
                return this;
            }

            public CognitoIdentity setIdentityPoolId(String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CognitoIdentity)) {
                    return false;
                }
                CognitoIdentity other = (CognitoIdentity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$amr = this.getAmr();
                List<String> other$amr = other.getAmr();
                if (this$amr == null ? other$amr != null : !((Object)this$amr).equals(other$amr)) {
                    return false;
                }
                String this$identityId = this.getIdentityId();
                String other$identityId = other.getIdentityId();
                if (this$identityId == null ? other$identityId != null : !this$identityId.equals(other$identityId)) {
                    return false;
                }
                String this$identityPoolId = this.getIdentityPoolId();
                String other$identityPoolId = other.getIdentityPoolId();
                return !(this$identityPoolId == null ? other$identityPoolId != null : !this$identityPoolId.equals(other$identityPoolId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof CognitoIdentity;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $amr = this.getAmr();
                result = result * 59 + ($amr == null ? 43 : ((Object)$amr).hashCode());
                String $identityId = this.getIdentityId();
                result = result * 59 + ($identityId == null ? 43 : $identityId.hashCode());
                String $identityPoolId = this.getIdentityPoolId();
                result = result * 59 + ($identityPoolId == null ? 43 : $identityPoolId.hashCode());
                return result;
            }

            public String toString() {
                return "APIGatewayV2HTTPEvent.RequestContext.CognitoIdentity(amr=" + this.getAmr() + ", identityId=" + this.getIdentityId() + ", identityPoolId=" + this.getIdentityPoolId() + ")";
            }
        }

        public static class IAM {
            private String accessKey;
            private String accountId;
            private String callerId;
            private CognitoIdentity cognitoIdentity;
            private String principalOrgId;
            private String userArn;
            private String userId;

            public String getAccessKey() {
                return this.accessKey;
            }

            public String getAccountId() {
                return this.accountId;
            }

            public String getCallerId() {
                return this.callerId;
            }

            public CognitoIdentity getCognitoIdentity() {
                return this.cognitoIdentity;
            }

            public String getPrincipalOrgId() {
                return this.principalOrgId;
            }

            public String getUserArn() {
                return this.userArn;
            }

            public String getUserId() {
                return this.userId;
            }

            public IAM setAccessKey(String accessKey) {
                this.accessKey = accessKey;
                return this;
            }

            public IAM setAccountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public IAM setCallerId(String callerId) {
                this.callerId = callerId;
                return this;
            }

            public IAM setCognitoIdentity(CognitoIdentity cognitoIdentity) {
                this.cognitoIdentity = cognitoIdentity;
                return this;
            }

            public IAM setPrincipalOrgId(String principalOrgId) {
                this.principalOrgId = principalOrgId;
                return this;
            }

            public IAM setUserArn(String userArn) {
                this.userArn = userArn;
                return this;
            }

            public IAM setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IAM)) {
                    return false;
                }
                IAM other = (IAM)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accessKey = this.getAccessKey();
                String other$accessKey = other.getAccessKey();
                if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                    return false;
                }
                String this$accountId = this.getAccountId();
                String other$accountId = other.getAccountId();
                if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                    return false;
                }
                String this$callerId = this.getCallerId();
                String other$callerId = other.getCallerId();
                if (this$callerId == null ? other$callerId != null : !this$callerId.equals(other$callerId)) {
                    return false;
                }
                CognitoIdentity this$cognitoIdentity = this.getCognitoIdentity();
                CognitoIdentity other$cognitoIdentity = other.getCognitoIdentity();
                if (this$cognitoIdentity == null ? other$cognitoIdentity != null : !((Object)this$cognitoIdentity).equals(other$cognitoIdentity)) {
                    return false;
                }
                String this$principalOrgId = this.getPrincipalOrgId();
                String other$principalOrgId = other.getPrincipalOrgId();
                if (this$principalOrgId == null ? other$principalOrgId != null : !this$principalOrgId.equals(other$principalOrgId)) {
                    return false;
                }
                String this$userArn = this.getUserArn();
                String other$userArn = other.getUserArn();
                if (this$userArn == null ? other$userArn != null : !this$userArn.equals(other$userArn)) {
                    return false;
                }
                String this$userId = this.getUserId();
                String other$userId = other.getUserId();
                return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof IAM;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accessKey = this.getAccessKey();
                result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
                String $accountId = this.getAccountId();
                result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
                String $callerId = this.getCallerId();
                result = result * 59 + ($callerId == null ? 43 : $callerId.hashCode());
                CognitoIdentity $cognitoIdentity = this.getCognitoIdentity();
                result = result * 59 + ($cognitoIdentity == null ? 43 : ((Object)$cognitoIdentity).hashCode());
                String $principalOrgId = this.getPrincipalOrgId();
                result = result * 59 + ($principalOrgId == null ? 43 : $principalOrgId.hashCode());
                String $userArn = this.getUserArn();
                result = result * 59 + ($userArn == null ? 43 : $userArn.hashCode());
                String $userId = this.getUserId();
                result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
                return result;
            }

            public String toString() {
                return "APIGatewayV2HTTPEvent.RequestContext.IAM(accessKey=" + this.getAccessKey() + ", accountId=" + this.getAccountId() + ", callerId=" + this.getCallerId() + ", cognitoIdentity=" + this.getCognitoIdentity() + ", principalOrgId=" + this.getPrincipalOrgId() + ", userArn=" + this.getUserArn() + ", userId=" + this.getUserId() + ")";
            }
        }

        public static class Http {
            private String method;
            private String path;
            private String protocol;
            private String sourceIp;
            private String userAgent;

            public String getMethod() {
                return this.method;
            }

            public String getPath() {
                return this.path;
            }

            public String getProtocol() {
                return this.protocol;
            }

            public String getSourceIp() {
                return this.sourceIp;
            }

            public String getUserAgent() {
                return this.userAgent;
            }

            public Http setMethod(String method) {
                this.method = method;
                return this;
            }

            public Http setPath(String path) {
                this.path = path;
                return this;
            }

            public Http setProtocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Http setSourceIp(String sourceIp) {
                this.sourceIp = sourceIp;
                return this;
            }

            public Http setUserAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http)) {
                    return false;
                }
                Http other = (Http)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$method = this.getMethod();
                String other$method = other.getMethod();
                if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                    return false;
                }
                String this$protocol = this.getProtocol();
                String other$protocol = other.getProtocol();
                if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                    return false;
                }
                String this$sourceIp = this.getSourceIp();
                String other$sourceIp = other.getSourceIp();
                if (this$sourceIp == null ? other$sourceIp != null : !this$sourceIp.equals(other$sourceIp)) {
                    return false;
                }
                String this$userAgent = this.getUserAgent();
                String other$userAgent = other.getUserAgent();
                return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Http;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $method = this.getMethod();
                result = result * 59 + ($method == null ? 43 : $method.hashCode());
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                String $protocol = this.getProtocol();
                result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
                String $sourceIp = this.getSourceIp();
                result = result * 59 + ($sourceIp == null ? 43 : $sourceIp.hashCode());
                String $userAgent = this.getUserAgent();
                result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                return result;
            }

            public String toString() {
                return "APIGatewayV2HTTPEvent.RequestContext.Http(method=" + this.getMethod() + ", path=" + this.getPath() + ", protocol=" + this.getProtocol() + ", sourceIp=" + this.getSourceIp() + ", userAgent=" + this.getUserAgent() + ")";
            }
        }

        public static class Authorizer {
            private JWT jwt;
            private IAM iam;
            private Map<String, Object> lambda;

            @NotNull
            public Map<String, Object> getLambda() {
                return this.lambda == null ? Collections.emptyMap() : this.lambda;
            }

            public JWT getJwt() {
                return this.jwt;
            }

            public IAM getIam() {
                return this.iam;
            }

            public Authorizer setJwt(JWT jwt) {
                this.jwt = jwt;
                return this;
            }

            public Authorizer setIam(IAM iam) {
                this.iam = iam;
                return this;
            }

            public Authorizer setLambda(Map<String, Object> lambda) {
                this.lambda = lambda;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Authorizer)) {
                    return false;
                }
                Authorizer other = (Authorizer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                JWT this$jwt = this.getJwt();
                JWT other$jwt = other.getJwt();
                if (this$jwt == null ? other$jwt != null : !((Object)this$jwt).equals(other$jwt)) {
                    return false;
                }
                IAM this$iam = this.getIam();
                IAM other$iam = other.getIam();
                if (this$iam == null ? other$iam != null : !((Object)this$iam).equals(other$iam)) {
                    return false;
                }
                Map<String, Object> this$lambda = this.getLambda();
                Map<String, Object> other$lambda = other.getLambda();
                return !(this$lambda == null ? other$lambda != null : !((Object)this$lambda).equals(other$lambda));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Authorizer;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JWT $jwt = this.getJwt();
                result = result * 59 + ($jwt == null ? 43 : ((Object)$jwt).hashCode());
                IAM $iam = this.getIam();
                result = result * 59 + ($iam == null ? 43 : ((Object)$iam).hashCode());
                Map<String, Object> $lambda = this.getLambda();
                result = result * 59 + ($lambda == null ? 43 : ((Object)$lambda).hashCode());
                return result;
            }

            public String toString() {
                return "APIGatewayV2HTTPEvent.RequestContext.Authorizer(jwt=" + this.getJwt() + ", iam=" + this.getIam() + ", lambda=" + this.getLambda() + ")";
            }

            public static class JWT {
                private Map<String, String> claims;
                private List<String> scopes;

                @NotNull
                public Map<String, String> getClaims() {
                    return this.claims == null ? Collections.emptyMap() : this.claims;
                }

                @NotNull
                public List<String> getScopes() {
                    return this.scopes == null ? Collections.emptyList() : this.scopes;
                }

                public JWT setClaims(Map<String, String> claims) {
                    this.claims = claims;
                    return this;
                }

                public JWT setScopes(List<String> scopes) {
                    this.scopes = scopes;
                    return this;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof JWT)) {
                        return false;
                    }
                    JWT other = (JWT)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, String> this$claims = this.getClaims();
                    Map<String, String> other$claims = other.getClaims();
                    if (this$claims == null ? other$claims != null : !((Object)this$claims).equals(other$claims)) {
                        return false;
                    }
                    List<String> this$scopes = this.getScopes();
                    List<String> other$scopes = other.getScopes();
                    return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof JWT;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, String> $claims = this.getClaims();
                    result = result * 59 + ($claims == null ? 43 : ((Object)$claims).hashCode());
                    List<String> $scopes = this.getScopes();
                    result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
                    return result;
                }

                public String toString() {
                    return "APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT(claims=" + this.getClaims() + ", scopes=" + this.getScopes() + ")";
                }
            }
        }
    }
}

