/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.kinesis;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KinesisEvent
implements Serializable {
    private List<KinesisEventRecord> records;

    @NotNull
    public List<KinesisEventRecord> getRecords() {
        return this.records == null ? Collections.emptyList() : this.records;
    }

    public KinesisEvent setRecords(List<KinesisEventRecord> records) {
        this.records = records;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisEvent)) {
            return false;
        }
        KinesisEvent other = (KinesisEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KinesisEventRecord> this$records = this.getRecords();
        List<KinesisEventRecord> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KinesisEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KinesisEventRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "KinesisEvent(records=" + this.getRecords() + ")";
    }

    public static class KinesisEventRecord
    implements Serializable {
        private String eventSource;
        private Record kinesis;
        private String eventID;
        private String invokeIdentityArn;
        private String eventName;
        private String eventVersion;
        private String eventSourceARN;
        private String awsRegion;

        public String getEventSource() {
            return this.eventSource;
        }

        public Record getKinesis() {
            return this.kinesis;
        }

        public String getEventID() {
            return this.eventID;
        }

        public String getInvokeIdentityArn() {
            return this.invokeIdentityArn;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public String getEventSourceARN() {
            return this.eventSourceARN;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public KinesisEventRecord setEventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public KinesisEventRecord setKinesis(Record kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public KinesisEventRecord setEventID(String eventID) {
            this.eventID = eventID;
            return this;
        }

        public KinesisEventRecord setInvokeIdentityArn(String invokeIdentityArn) {
            this.invokeIdentityArn = invokeIdentityArn;
            return this;
        }

        public KinesisEventRecord setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public KinesisEventRecord setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public KinesisEventRecord setEventSourceARN(String eventSourceARN) {
            this.eventSourceARN = eventSourceARN;
            return this;
        }

        public KinesisEventRecord setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KinesisEventRecord)) {
                return false;
            }
            KinesisEventRecord other = (KinesisEventRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$eventSource = this.getEventSource();
            String other$eventSource = other.getEventSource();
            if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
                return false;
            }
            Record this$kinesis = this.getKinesis();
            Record other$kinesis = other.getKinesis();
            if (this$kinesis == null ? other$kinesis != null : !((Object)this$kinesis).equals(other$kinesis)) {
                return false;
            }
            String this$eventID = this.getEventID();
            String other$eventID = other.getEventID();
            if (this$eventID == null ? other$eventID != null : !this$eventID.equals(other$eventID)) {
                return false;
            }
            String this$invokeIdentityArn = this.getInvokeIdentityArn();
            String other$invokeIdentityArn = other.getInvokeIdentityArn();
            if (this$invokeIdentityArn == null ? other$invokeIdentityArn != null : !this$invokeIdentityArn.equals(other$invokeIdentityArn)) {
                return false;
            }
            String this$eventName = this.getEventName();
            String other$eventName = other.getEventName();
            if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
                return false;
            }
            String this$eventVersion = this.getEventVersion();
            String other$eventVersion = other.getEventVersion();
            if (this$eventVersion == null ? other$eventVersion != null : !this$eventVersion.equals(other$eventVersion)) {
                return false;
            }
            String this$eventSourceARN = this.getEventSourceARN();
            String other$eventSourceARN = other.getEventSourceARN();
            if (this$eventSourceARN == null ? other$eventSourceARN != null : !this$eventSourceARN.equals(other$eventSourceARN)) {
                return false;
            }
            String this$awsRegion = this.getAwsRegion();
            String other$awsRegion = other.getAwsRegion();
            return !(this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KinesisEventRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $eventSource = this.getEventSource();
            result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
            Record $kinesis = this.getKinesis();
            result = result * 59 + ($kinesis == null ? 43 : ((Object)$kinesis).hashCode());
            String $eventID = this.getEventID();
            result = result * 59 + ($eventID == null ? 43 : $eventID.hashCode());
            String $invokeIdentityArn = this.getInvokeIdentityArn();
            result = result * 59 + ($invokeIdentityArn == null ? 43 : $invokeIdentityArn.hashCode());
            String $eventName = this.getEventName();
            result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
            String $eventVersion = this.getEventVersion();
            result = result * 59 + ($eventVersion == null ? 43 : $eventVersion.hashCode());
            String $eventSourceARN = this.getEventSourceARN();
            result = result * 59 + ($eventSourceARN == null ? 43 : $eventSourceARN.hashCode());
            String $awsRegion = this.getAwsRegion();
            result = result * 59 + ($awsRegion == null ? 43 : $awsRegion.hashCode());
            return result;
        }

        public String toString() {
            return "KinesisEvent.KinesisEventRecord(eventSource=" + this.getEventSource() + ", kinesis=" + this.getKinesis() + ", eventID=" + this.getEventID() + ", invokeIdentityArn=" + this.getInvokeIdentityArn() + ", eventName=" + this.getEventName() + ", eventVersion=" + this.getEventVersion() + ", eventSourceARN=" + this.getEventSourceARN() + ", awsRegion=" + this.getAwsRegion() + ")";
        }
    }

    public static class Record {
        private String sequenceNumber;
        private long approximateArrivalTimestamp;
        private byte[] data;
        private String partitionKey;
        private EncryptionType encryptionType;
        private String kinesisSchemaVersion;

        public String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public long getApproximateArrivalTimestamp() {
            return this.approximateArrivalTimestamp;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public EncryptionType getEncryptionType() {
            return this.encryptionType;
        }

        public String getKinesisSchemaVersion() {
            return this.kinesisSchemaVersion;
        }

        public Record setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Record setApproximateArrivalTimestamp(long approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            return this;
        }

        public Record setData(byte[] data) {
            this.data = data;
            return this;
        }

        public Record setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Record setEncryptionType(EncryptionType encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public Record setKinesisSchemaVersion(String kinesisSchemaVersion) {
            this.kinesisSchemaVersion = kinesisSchemaVersion;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record other = (Record)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getApproximateArrivalTimestamp() != other.getApproximateArrivalTimestamp()) {
                return false;
            }
            String this$sequenceNumber = this.getSequenceNumber();
            String other$sequenceNumber = other.getSequenceNumber();
            if (this$sequenceNumber == null ? other$sequenceNumber != null : !this$sequenceNumber.equals(other$sequenceNumber)) {
                return false;
            }
            if (!Arrays.equals(this.getData(), other.getData())) {
                return false;
            }
            String this$partitionKey = this.getPartitionKey();
            String other$partitionKey = other.getPartitionKey();
            if (this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey)) {
                return false;
            }
            EncryptionType this$encryptionType = this.getEncryptionType();
            EncryptionType other$encryptionType = other.getEncryptionType();
            if (this$encryptionType == null ? other$encryptionType != null : !((Object)((Object)this$encryptionType)).equals((Object)other$encryptionType)) {
                return false;
            }
            String this$kinesisSchemaVersion = this.getKinesisSchemaVersion();
            String other$kinesisSchemaVersion = other.getKinesisSchemaVersion();
            return !(this$kinesisSchemaVersion == null ? other$kinesisSchemaVersion != null : !this$kinesisSchemaVersion.equals(other$kinesisSchemaVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Record;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
            result = result * 59 + (int)($approximateArrivalTimestamp >>> 32 ^ $approximateArrivalTimestamp);
            String $sequenceNumber = this.getSequenceNumber();
            result = result * 59 + ($sequenceNumber == null ? 43 : $sequenceNumber.hashCode());
            result = result * 59 + Arrays.hashCode(this.getData());
            String $partitionKey = this.getPartitionKey();
            result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
            EncryptionType $encryptionType = this.getEncryptionType();
            result = result * 59 + ($encryptionType == null ? 43 : ((Object)((Object)$encryptionType)).hashCode());
            String $kinesisSchemaVersion = this.getKinesisSchemaVersion();
            result = result * 59 + ($kinesisSchemaVersion == null ? 43 : $kinesisSchemaVersion.hashCode());
            return result;
        }

        public String toString() {
            return "KinesisEvent.Record(sequenceNumber=" + this.getSequenceNumber() + ", approximateArrivalTimestamp=" + this.getApproximateArrivalTimestamp() + ", data=" + Arrays.toString(this.getData()) + ", partitionKey=" + this.getPartitionKey() + ", encryptionType=" + this.getEncryptionType() + ", kinesisSchemaVersion=" + this.getKinesisSchemaVersion() + ")";
        }

        public static enum EncryptionType {
            NONE,
            KMS;

        }
    }
}

