/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.kinesis;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class KinesisFirehoseEvent
implements Serializable {
    private String invocationId;
    private String deliveryStreamArn;
    private String region;
    private List<Record> records;

    @NotNull
    public List<Record> getRecords() {
        return this.records == null ? Collections.emptyList() : this.records;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public String getDeliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    public String getRegion() {
        return this.region;
    }

    public KinesisFirehoseEvent setInvocationId(String invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    public KinesisFirehoseEvent setDeliveryStreamArn(String deliveryStreamArn) {
        this.deliveryStreamArn = deliveryStreamArn;
        return this;
    }

    public KinesisFirehoseEvent setRegion(String region) {
        this.region = region;
        return this;
    }

    public KinesisFirehoseEvent setRecords(List<Record> records) {
        this.records = records;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisFirehoseEvent)) {
            return false;
        }
        KinesisFirehoseEvent other = (KinesisFirehoseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$invocationId = this.getInvocationId();
        String other$invocationId = other.getInvocationId();
        if (this$invocationId == null ? other$invocationId != null : !this$invocationId.equals(other$invocationId)) {
            return false;
        }
        String this$deliveryStreamArn = this.getDeliveryStreamArn();
        String other$deliveryStreamArn = other.getDeliveryStreamArn();
        if (this$deliveryStreamArn == null ? other$deliveryStreamArn != null : !this$deliveryStreamArn.equals(other$deliveryStreamArn)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        List<Record> this$records = this.getRecords();
        List<Record> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KinesisFirehoseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $invocationId = this.getInvocationId();
        result = result * 59 + ($invocationId == null ? 43 : $invocationId.hashCode());
        String $deliveryStreamArn = this.getDeliveryStreamArn();
        result = result * 59 + ($deliveryStreamArn == null ? 43 : $deliveryStreamArn.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        List<Record> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "KinesisFirehoseEvent(invocationId=" + this.getInvocationId() + ", deliveryStreamArn=" + this.getDeliveryStreamArn() + ", region=" + this.getRegion() + ", records=" + this.getRecords() + ")";
    }

    public static class Record
    implements Serializable {
        private byte[] data;
        private String recordId;
        private long approximateArrivalEpoch;
        private long approximateArrivalTimestamp;
        private Map<String, String> kinesisRecordMetadata;

        @NotNull
        public Map<String, String> getKinesisRecordMetadata() {
            return this.kinesisRecordMetadata == null ? Collections.emptyMap() : this.kinesisRecordMetadata;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getRecordId() {
            return this.recordId;
        }

        public long getApproximateArrivalEpoch() {
            return this.approximateArrivalEpoch;
        }

        public long getApproximateArrivalTimestamp() {
            return this.approximateArrivalTimestamp;
        }

        public Record setData(byte[] data) {
            this.data = data;
            return this;
        }

        public Record setRecordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public Record setApproximateArrivalEpoch(long approximateArrivalEpoch) {
            this.approximateArrivalEpoch = approximateArrivalEpoch;
            return this;
        }

        public Record setApproximateArrivalTimestamp(long approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            return this;
        }

        public Record setKinesisRecordMetadata(Map<String, String> kinesisRecordMetadata) {
            this.kinesisRecordMetadata = kinesisRecordMetadata;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record other = (Record)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getApproximateArrivalEpoch() != other.getApproximateArrivalEpoch()) {
                return false;
            }
            if (this.getApproximateArrivalTimestamp() != other.getApproximateArrivalTimestamp()) {
                return false;
            }
            if (!Arrays.equals(this.getData(), other.getData())) {
                return false;
            }
            String this$recordId = this.getRecordId();
            String other$recordId = other.getRecordId();
            if (this$recordId == null ? other$recordId != null : !this$recordId.equals(other$recordId)) {
                return false;
            }
            Map<String, String> this$kinesisRecordMetadata = this.getKinesisRecordMetadata();
            Map<String, String> other$kinesisRecordMetadata = other.getKinesisRecordMetadata();
            return !(this$kinesisRecordMetadata == null ? other$kinesisRecordMetadata != null : !((Object)this$kinesisRecordMetadata).equals(other$kinesisRecordMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Record;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $approximateArrivalEpoch = this.getApproximateArrivalEpoch();
            result = result * 59 + (int)($approximateArrivalEpoch >>> 32 ^ $approximateArrivalEpoch);
            long $approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
            result = result * 59 + (int)($approximateArrivalTimestamp >>> 32 ^ $approximateArrivalTimestamp);
            result = result * 59 + Arrays.hashCode(this.getData());
            String $recordId = this.getRecordId();
            result = result * 59 + ($recordId == null ? 43 : $recordId.hashCode());
            Map<String, String> $kinesisRecordMetadata = this.getKinesisRecordMetadata();
            result = result * 59 + ($kinesisRecordMetadata == null ? 43 : ((Object)$kinesisRecordMetadata).hashCode());
            return result;
        }

        public String toString() {
            return "KinesisFirehoseEvent.Record(data=" + Arrays.toString(this.getData()) + ", recordId=" + this.getRecordId() + ", approximateArrivalEpoch=" + this.getApproximateArrivalEpoch() + ", approximateArrivalTimestamp=" + this.getApproximateArrivalTimestamp() + ", kinesisRecordMetadata=" + this.getKinesisRecordMetadata() + ")";
        }
    }
}

