/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class Price {
    private double ethusd;
    private double ethbtc;
    private String ethusd_timestamp;
    private String ethbtc_timestamp;
    private LocalDateTime _ethusd_timestamp;
    private LocalDateTime _ethbtc_timestamp;

    public double inUsd() {
        return this.ethusd;
    }

    public double inBtc() {
        return this.ethbtc;
    }

    public LocalDateTime usdTimestamp() {
        if (this._ethusd_timestamp == null) {
            this._ethusd_timestamp = LocalDateTime.ofEpochSecond(Long.valueOf(this.ethusd_timestamp), 0, ZoneOffset.UTC);
        }
        return this._ethusd_timestamp;
    }

    public LocalDateTime btcTimestamp() {
        if (this._ethbtc_timestamp == null) {
            this._ethbtc_timestamp = LocalDateTime.ofEpochSecond(Long.valueOf(this.ethbtc_timestamp), 0, ZoneOffset.UTC);
        }
        return this._ethbtc_timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Price price = (Price)o;
        if (Double.compare(price.ethusd, this.ethusd) != 0) {
            return false;
        }
        if (Double.compare(price.ethbtc, this.ethbtc) != 0) {
            return false;
        }
        if (this.ethusd_timestamp != null ? !this.ethusd_timestamp.equals(price.ethusd_timestamp) : price.ethusd_timestamp != null) {
            return false;
        }
        if (this.ethbtc_timestamp != null ? !this.ethbtc_timestamp.equals(price.ethbtc_timestamp) : price.ethbtc_timestamp != null) {
            return false;
        }
        if (this._ethusd_timestamp != null ? !this._ethusd_timestamp.equals(price._ethusd_timestamp) : price._ethusd_timestamp != null) {
            return false;
        }
        return this._ethbtc_timestamp != null ? this._ethbtc_timestamp.equals(price._ethbtc_timestamp) : price._ethbtc_timestamp == null;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.ethusd);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.ethbtc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.ethusd_timestamp != null ? this.ethusd_timestamp.hashCode() : 0);
        result = 31 * result + (this.ethbtc_timestamp != null ? this.ethbtc_timestamp.hashCode() : 0);
        result = 31 * result + (this._ethusd_timestamp != null ? this._ethusd_timestamp.hashCode() : 0);
        result = 31 * result + (this._ethbtc_timestamp != null ? this._ethbtc_timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Price{ethusd=" + this.ethusd + ", ethbtc=" + this.ethbtc + ", ethusd_timestamp='" + this.ethusd_timestamp + '\'' + ", ethbtc_timestamp='" + this.ethbtc_timestamp + '\'' + ", _ethusd_timestamp=" + this._ethusd_timestamp + ", _ethbtc_timestamp=" + this._ethbtc_timestamp + '}';
    }
}

