/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.model.BaseTx;

public class TxToken
extends BaseTx {
    private long nonce;
    private String blockHash;
    private String tokenName;
    private String tokenSymbol;
    private String tokenDecimal;
    private int transactionIndex;
    private long gasPrice;
    private long cumulativeGasUsed;
    private long confirmations;

    public long getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public String getTokenDecimal() {
        return this.tokenDecimal;
    }

    public int getTransactionIndex() {
        return this.transactionIndex;
    }

    public long getGasPrice() {
        return this.gasPrice;
    }

    public long getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public long getConfirmations() {
        return this.confirmations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxToken txToken = (TxToken)o;
        if (this.nonce != txToken.nonce) {
            return false;
        }
        if (this.transactionIndex != txToken.transactionIndex) {
            return false;
        }
        if (this.gasPrice != txToken.gasPrice) {
            return false;
        }
        if (this.cumulativeGasUsed != txToken.cumulativeGasUsed) {
            return false;
        }
        if (this.confirmations != txToken.confirmations) {
            return false;
        }
        if (this.blockHash != null ? !this.blockHash.equals(txToken.blockHash) : txToken.blockHash != null) {
            return false;
        }
        if (this.tokenName != null ? !this.tokenName.equals(txToken.tokenName) : txToken.tokenName != null) {
            return false;
        }
        if (this.tokenSymbol != null ? !this.tokenSymbol.equals(txToken.tokenSymbol) : txToken.tokenSymbol != null) {
            return false;
        }
        return this.tokenDecimal != null ? this.tokenDecimal.equals(txToken.tokenDecimal) : txToken.tokenDecimal == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.nonce ^ this.nonce >>> 32);
        result = 31 * result + (this.blockHash != null ? this.blockHash.hashCode() : 0);
        result = 31 * result + (this.tokenName != null ? this.tokenName.hashCode() : 0);
        result = 31 * result + (this.tokenSymbol != null ? this.tokenSymbol.hashCode() : 0);
        result = 31 * result + (this.tokenDecimal != null ? this.tokenDecimal.hashCode() : 0);
        result = 31 * result + this.transactionIndex;
        result = 31 * result + (int)(this.gasPrice ^ this.gasPrice >>> 32);
        result = 31 * result + (int)(this.cumulativeGasUsed ^ this.cumulativeGasUsed >>> 32);
        result = 31 * result + (int)(this.confirmations ^ this.confirmations >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "TxToken{nonce=" + this.nonce + ", blockHash='" + this.blockHash + '\'' + ", tokenName='" + this.tokenName + '\'' + ", tokenSymbol='" + this.tokenSymbol + '\'' + ", tokenDecimal='" + this.tokenDecimal + '\'' + ", transactionIndex=" + this.transactionIndex + ", gasPrice=" + this.gasPrice + ", cumulativeGasUsed=" + this.cumulativeGasUsed + ", confirmations=" + this.confirmations + '}';
    }
}

