/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IAccountApi;
import io.api.etherscan.core.IBlockApi;
import io.api.etherscan.core.IContractApi;
import io.api.etherscan.core.ILogsApi;
import io.api.etherscan.core.IProxyApi;
import io.api.etherscan.core.IStatisticApi;
import io.api.etherscan.core.ITransactionApi;
import io.api.etherscan.core.impl.AccountApiProvider;
import io.api.etherscan.core.impl.BlockApiProvider;
import io.api.etherscan.core.impl.ContractApiProvider;
import io.api.etherscan.core.impl.LogsApiProvider;
import io.api.etherscan.core.impl.ProxyApiProvider;
import io.api.etherscan.core.impl.StatisticApiProvider;
import io.api.etherscan.core.impl.TransactionApiProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.ApiKeyException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.executor.impl.HttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.manager.impl.FakeQueueManager;
import io.api.etherscan.manager.impl.QueueManager;
import io.api.etherscan.model.EthNetwork;
import io.api.etherscan.util.BasicUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EtherScanApi {
    private static final Supplier<IHttpExecutor> DEFAULT_SUPPLIER = HttpExecutor::new;
    public static final String DEFAULT_KEY = "YourApiKeyToken";
    private final IAccountApi account;
    private final IBlockApi block;
    private final IContractApi contract;
    private final ILogsApi logs;
    private final IProxyApi proxy;
    private final IStatisticApi stats;
    private final ITransactionApi txs;

    public EtherScanApi() {
        this(DEFAULT_KEY, EthNetwork.MAINNET);
    }

    public EtherScanApi(EthNetwork network) {
        this(DEFAULT_KEY, network);
    }

    public EtherScanApi(String apiKey) {
        this(apiKey, EthNetwork.MAINNET);
    }

    public EtherScanApi(EthNetwork network, Supplier<IHttpExecutor> executorSupplier) {
        this(DEFAULT_KEY, network, executorSupplier);
    }

    public EtherScanApi(String apiKey, EthNetwork network, IQueueManager queue) {
        this(apiKey, network, DEFAULT_SUPPLIER, queue);
    }

    public EtherScanApi(String apiKey, EthNetwork network) {
        this(apiKey, network, DEFAULT_SUPPLIER);
    }

    public EtherScanApi(String apiKey, EthNetwork network, Supplier<IHttpExecutor> executorSupplier) {
        this(apiKey, network, executorSupplier, DEFAULT_KEY.equals(apiKey) ? QueueManager.DEFAULT_KEY_QUEUE : new FakeQueueManager());
    }

    public EtherScanApi(String apiKey, EthNetwork network, Supplier<IHttpExecutor> executorSupplier, IQueueManager queue) {
        if (BasicUtils.isBlank(apiKey)) {
            throw new ApiKeyException("API key can not be null or empty");
        }
        if (network == null) {
            throw new ApiException("Ethereum Network is set to NULL value");
        }
        IHttpExecutor executor = executorSupplier.get();
        String ending = EthNetwork.TOBALABA.equals((Object)network) ? "com" : "io";
        String baseUrl = "https://" + network.getDomain() + ".etherscan." + ending + "/api?apikey=" + apiKey;
        this.account = new AccountApiProvider(queue, baseUrl, executor);
        this.block = new BlockApiProvider(queue, baseUrl, executor);
        this.contract = new ContractApiProvider(queue, baseUrl, executor);
        this.logs = new LogsApiProvider(queue, baseUrl, executor);
        this.proxy = new ProxyApiProvider(queue, baseUrl, executor);
        this.stats = new StatisticApiProvider(queue, baseUrl, executor);
        this.txs = new TransactionApiProvider(queue, baseUrl, executor);
    }

    @NotNull
    public IAccountApi account() {
        return this.account;
    }

    @NotNull
    public IContractApi contract() {
        return this.contract;
    }

    @NotNull
    public ITransactionApi txs() {
        return this.txs;
    }

    @NotNull
    public IBlockApi block() {
        return this.block;
    }

    @NotNull
    public ILogsApi logs() {
        return this.logs;
    }

    @NotNull
    public IProxyApi proxy() {
        return this.proxy;
    }

    @NotNull
    public IStatisticApi stats() {
        return this.stats;
    }
}

