/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IProxyApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.error.InvalidDataHexException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.proxy.BlockProxy;
import io.api.etherscan.model.proxy.ReceiptProxy;
import io.api.etherscan.model.proxy.TxProxy;
import io.api.etherscan.model.proxy.utility.BlockProxyTO;
import io.api.etherscan.model.proxy.utility.StringProxyTO;
import io.api.etherscan.model.proxy.utility.TxInfoProxyTO;
import io.api.etherscan.model.proxy.utility.TxProxyTO;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ProxyApiProvider
extends BasicProvider
implements IProxyApi {
    private static final String ACT_BLOCKNO_PARAM = "&action=eth_blockNumber";
    private static final String ACT_BY_BLOCKNO_PARAM = "&action=eth_getBlockByNumber";
    private static final String ACT_UNCLE_BY_BLOCKNOINDEX_PARAM = "&action=eth_getUncleByBlockNumberAndIndex";
    private static final String ACT_BLOCKTX_COUNT_PARAM = "&action=eth_getBlockTransactionCountByNumber";
    private static final String ACT_TX_BY_HASH_PARAM = "&action=eth_getTransactionByHash";
    private static final String ACT_TX_BY_BLOCKNOINDEX_PARAM = "&action=eth_getTransactionByBlockNumberAndIndex";
    private static final String ACT_TX_COUNT_PARAM = "&action=eth_getTransactionCount";
    private static final String ACT_SEND_RAW_TX_PARAM = "&action=eth_sendRawTransaction";
    private static final String ACT_TX_RECEIPT_PARAM = "&action=eth_getTransactionReceipt";
    private static final String ACT_CALL_PARAM = "&action=eth_call";
    private static final String ACT_CODE_PARAM = "&action=eth_getCode";
    private static final String ACT_STORAGEAT_PARAM = "&action=eth_getStorageAt";
    private static final String ACT_GASPRICE_PARAM = "&action=eth_gasPrice";
    private static final String ACT_ESTIMATEGAS_PARAM = "&action=eth_estimateGas";
    private static final String BOOLEAN_PARAM = "&boolean=true";
    private static final String TAG_LAST_PARAM = "&tag=latest";
    private static final String POSITION_PARAM = "&position=";
    private static final String ADDRESS_PARAM = "&address=";
    private static final String TXHASH_PARAM = "&txhash=";
    private static final String INDEX_PARAM = "&index=";
    private static final String DATA_PARAM = "&data=";
    private static final String GAS_PARAM = "&gas=";
    private static final String TAG_PARAM = "&tag=";
    private static final String HEX_PARAM = "&hex=";
    private static final String TO_PARAM = "&to=";
    private static final Pattern EMPTY_HEX = Pattern.compile("0x0+");

    ProxyApiProvider(IQueueManager queue, String baseUrl, IHttpExecutor executor) {
        super(queue, "proxy", baseUrl, executor);
    }

    @Override
    public long blockNoLast() throws ApiException {
        StringProxyTO response = this.getRequest(ACT_BLOCKNO_PARAM, StringProxyTO.class);
        return BasicUtils.isEmpty(response.getResult()) ? -1L : BasicUtils.parseHex(response.getResult()).longValue();
    }

    @Override
    @NotNull
    public Optional<BlockProxy> block(long blockNo) throws ApiException {
        long compBlockNo = BasicUtils.compensateMinBlock(blockNo);
        String urlParams = "&action=eth_getBlockByNumber&tag=" + compBlockNo + BOOLEAN_PARAM;
        BlockProxyTO response = this.getRequest(urlParams, BlockProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<BlockProxy> blockUncle(long blockNo, long index) throws ApiException {
        long compBlockNo = BasicUtils.compensateMinBlock(blockNo);
        long compIndex = BasicUtils.compensateMinBlock(index);
        String urlParams = "&action=eth_getUncleByBlockNumberAndIndex&tag=0x" + Long.toHexString(compBlockNo) + INDEX_PARAM + "0x" + Long.toHexString(compIndex);
        BlockProxyTO response = this.getRequest(urlParams, BlockProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<TxProxy> tx(String txhash) throws ApiException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=eth_getTransactionByHash&txhash=" + txhash;
        TxProxyTO response = this.getRequest(urlParams, TxProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<TxProxy> tx(long blockNo, long index) throws ApiException {
        long compBlockNo = BasicUtils.compensateMinBlock(blockNo);
        long compIndex = index < 1L ? 1L : index;
        String urlParams = "&action=eth_getTransactionByBlockNumberAndIndex&tag=" + compBlockNo + INDEX_PARAM + "0x" + Long.toHexString(compIndex);
        TxProxyTO response = this.getRequest(urlParams, TxProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    public int txCount(long blockNo) throws ApiException {
        long compensatedBlockNo = BasicUtils.compensateMinBlock(blockNo);
        String urlParams = "&action=eth_getBlockTransactionCountByNumber&tag=0x" + Long.toHexString(compensatedBlockNo);
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return BasicUtils.parseHex(response.getResult()).intValue();
    }

    @Override
    public int txSendCount(String address) throws ApiException {
        BasicUtils.validateAddress(address);
        String urlParams = "&action=eth_getTransactionCount&address=" + address + TAG_LAST_PARAM;
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return BasicUtils.parseHex(response.getResult()).intValue();
    }

    @Override
    @NotNull
    public Optional<String> txSendRaw(String hexEncodedTx) throws ApiException {
        if (BasicUtils.isNotHex(hexEncodedTx)) {
            throw new InvalidDataHexException("Data is not encoded in hex format - " + hexEncodedTx);
        }
        String urlParams = "&action=eth_sendRawTransaction&hex=" + hexEncodedTx;
        StringProxyTO response = this.postRequest(urlParams, "", StringProxyTO.class);
        if (response.getError() != null) {
            throw new EtherScanException("Error occurred with code " + response.getError().getCode() + " with message " + response.getError().getMessage() + ", error id " + response.getId() + ", jsonRPC " + response.getJsonrpc());
        }
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<ReceiptProxy> txReceipt(String txhash) throws ApiException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=eth_getTransactionReceipt&txhash=" + txhash;
        TxInfoProxyTO response = this.getRequest(urlParams, TxInfoProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<String> call(String address, String data) throws ApiException {
        BasicUtils.validateAddress(address);
        if (BasicUtils.isNotHex(data)) {
            throw new InvalidDataHexException("Data is not hex encoded.");
        }
        String urlParams = "&action=eth_call&to=" + address + DATA_PARAM + data + TAG_LAST_PARAM;
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<String> code(String address) throws ApiException {
        BasicUtils.validateAddress(address);
        String urlParams = "&action=eth_getCode&address=" + address + TAG_LAST_PARAM;
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<String> storageAt(String address, long position) throws ApiException {
        BasicUtils.validateAddress(address);
        long compPosition = BasicUtils.compensateMinBlock(position);
        String urlParams = "&action=eth_getStorageAt&address=" + address + POSITION_PARAM + compPosition + TAG_LAST_PARAM;
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return BasicUtils.isEmpty(response.getResult()) || EMPTY_HEX.matcher(response.getResult()).matches() ? Optional.empty() : Optional.of(response.getResult());
    }

    @Override
    @NotNull
    public BigInteger gasPrice() throws ApiException {
        StringProxyTO response = this.getRequest(ACT_GASPRICE_PARAM, StringProxyTO.class);
        return BasicUtils.isEmpty(response.getResult()) ? BigInteger.valueOf(-1L) : BasicUtils.parseHex(response.getResult());
    }

    @Override
    @NotNull
    public BigInteger gasEstimated() throws ApiException {
        return this.gasEstimated("606060405260728060106000396000f360606040526000");
    }

    @Override
    @NotNull
    public BigInteger gasEstimated(String hexData) throws ApiException {
        if (!BasicUtils.isEmpty(hexData) && BasicUtils.isNotHex(hexData)) {
            throw new InvalidDataHexException("Data is not in hex format.");
        }
        String urlParams = "&action=eth_estimateGas&data=" + hexData + GAS_PARAM + "2000000000000000";
        StringProxyTO response = this.getRequest(urlParams, StringProxyTO.class);
        return BasicUtils.isEmpty(response.getResult()) ? BigInteger.valueOf(-1L) : BasicUtils.parseHex(response.getResult());
    }
}

