/*
 * Decompiled with CFR 0.152.
 */
package com.github.halab4dev.mongo2j.mapper;

import com.github.halab4dev.mongo2j.annotation.BsonId;
import com.github.halab4dev.mongo2j.util.BsonUtils;
import com.github.halab4dev.mongo2j.util.ClassUtils;
import com.github.halab4dev.mongo2j.util.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.bson.Document;
import org.bson.types.ObjectId;

public class BsonDeserializer {
    private static final String ID = "_id";
    private static final String STRING = "String";
    private static final String CHARACTER = "Character";
    private static final String PRIMITIVE_CHARACTER = "char";
    private static final String BOOLEAN = "Boolean";
    private static final String PRIMITIVE_BOOLEAN = "boolean";
    private static final String BYTE = "Byte";
    private static final String PRIMITIVE_BYTE = "byte";
    private static final String SHORT = "Short";
    private static final String PRIMITIVE_SHORT = "short";
    private static final String INTEGER = "Integer";
    private static final String PRIMITIVE_INTEGER = "int";
    private static final String LONG = "Long";
    private static final String PRIMITIVE_LONG = "long";
    private static final String FLOAT = "Float";
    private static final String PRIMITIVE_FLOAT = "float";
    private static final String DOUBLE = "Double";
    private static final String PRIMITIVE_DOUBLE = "double";

    public <T> T toObject(Document document, Class<T> type) {
        T t;
        if (Validator.isNull(document)) {
            return null;
        }
        try {
            t = type.newInstance();
            List<Field> fields = ClassUtils.getSuperClassField(type);
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
            for (Field field : fields) {
                this.setObjectField(t, field, document);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Class does not have no argument constructor", e);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    private void setObjectField(Object object, Field field, Document document) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        field.setAccessible(true);
        if (field.isAnnotationPresent(BsonId.class)) {
            this.setObjectIdField(object, field, document);
        } else if (ClassUtils.isSimpleValue(field)) {
            this.setSimpleValueField(object, field, document);
        } else if (ClassUtils.isDate(field)) {
            this.setDateValueField(object, field, document);
        } else if (ClassUtils.isCollection(field)) {
            this.setCollectionField(object, field, document);
        } else if (ClassUtils.isMap(field)) {
            this.setMapField(object, field, document);
        } else {
            this.setComplexValueField(object, field, document);
        }
    }

    private void setObjectIdField(Object object, Field field, Document document) throws IllegalAccessException {
        ObjectId objectId = document.getObjectId((Object)ID);
        if (Validator.isNull(objectId)) {
            return;
        }
        if (field.getType().isAssignableFrom(ObjectId.class)) {
            field.set(object, objectId);
        } else if (field.getType().isAssignableFrom(String.class)) {
            field.set(object, objectId.toString());
        } else {
            throw new IllegalArgumentException("DocumentId field must be Object Id or String");
        }
    }

    private void setSimpleValueField(Object object, Field field, Document document) throws IllegalAccessException {
        String fieldName = BsonUtils.getDocumentFieldName(field);
        if (Validator.isNull(document.get((Object)fieldName))) {
            return;
        }
        Class<?> fieldClass = field.getType();
        switch (fieldClass.getSimpleName()) {
            case "String": {
                field.set(object, document.getString((Object)fieldName));
                break;
            }
            case "boolean": 
            case "Boolean": {
                field.set(object, document.getBoolean((Object)fieldName));
                break;
            }
            case "int": 
            case "Integer": {
                field.set(object, document.getInteger((Object)fieldName));
                break;
            }
            case "long": 
            case "Long": {
                field.set(object, document.getLong((Object)fieldName));
                break;
            }
            case "char": 
            case "Character": 
            case "byte": 
            case "Byte": 
            case "short": 
            case "Short": 
            case "float": 
            case "Float": {
                field.set(object, document.get((Object)fieldName));
                break;
            }
            case "double": 
            case "Double": {
                field.set(object, document.getDouble((Object)fieldName));
            }
        }
    }

    private void setDateValueField(Object object, Field field, Document document) throws IllegalAccessException {
        String fieldName = BsonUtils.getDocumentFieldName(field);
        Date date = document.getDate((Object)fieldName);
        field.set(object, date);
    }

    private void setCollectionField(Object object, Field field, Document document) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String fieldName = BsonUtils.getDocumentFieldName(field);
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Class elementType = (Class)parameterizedType.getActualTypeArguments()[0];
        if (Set.class.isAssignableFrom(field.getType())) {
            Set dbSet = (Set)document.get((Object)fieldName, new HashSet());
            Set<?> collection = this.createNewSetInstance(field);
            for (Object dbObject : dbSet) {
                if (ClassUtils.isWrappedClass(elementType)) {
                    collection.add(dbObject);
                    continue;
                }
                collection.add(this.toObject((Document)dbObject, elementType));
            }
            field.set(object, collection);
        } else {
            List dbList = (List)document.get((Object)fieldName, new ArrayList());
            List<?> collection = this.createNewListInstance(field);
            for (Object dbObject : dbList) {
                if (ClassUtils.isWrappedClass(elementType)) {
                    collection.add(dbObject);
                    continue;
                }
                collection.add(this.toObject((Document)dbObject, elementType));
            }
            field.set(object, collection);
        }
    }

    private Set<?> createNewSetInstance(Field field) {
        if (SortedSet.class.isAssignableFrom(field.getType())) {
            return new TreeSet();
        }
        if (LinkedHashSet.class.isAssignableFrom(field.getType())) {
            return new LinkedHashSet();
        }
        return new HashSet();
    }

    private List<?> createNewListInstance(Field field) {
        if (Stack.class.isAssignableFrom(field.getType())) {
            return new Stack();
        }
        if (Vector.class.isAssignableFrom(field.getType())) {
            return new Vector();
        }
        if (LinkedList.class.isAssignableFrom(field.getType())) {
            return new LinkedList();
        }
        return new ArrayList();
    }

    private void setMapField(Object object, Field field, Document document) throws IllegalAccessException, ClassNotFoundException {
        String fieldName = BsonUtils.getDocumentFieldName(field);
        Document subDocument = (Document)document.get((Object)fieldName);
        field.setAccessible(true);
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Type type = parameterizedType.getActualTypeArguments()[1];
        Class<?> clazz = Class.forName(type.getTypeName());
        HashMap map = new HashMap();
        subDocument.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (ClassUtils.isSimpleValue(value)) {
                map.put(key, value);
            } else {
                map.put(key, this.toObject((Document)value, clazz));
            }
        });
        field.set(object, map);
    }

    private void setComplexValueField(Object object, Field field, Document document) throws IllegalAccessException {
        String fieldName = BsonUtils.getDocumentFieldName(field);
        Class<?> fieldClass = field.getType();
        Object subObject = fieldClass.cast(this.toObject((Document)document.get((Object)fieldName), fieldClass));
        field.set(object, subObject);
    }
}

