/*
 * Decompiled with CFR 0.152.
 */
package com.github.halab4dev.mongo2j.mapper;

import com.github.halab4dev.mongo2j.annotation.BsonId;
import com.github.halab4dev.mongo2j.util.BsonUtils;
import com.github.halab4dev.mongo2j.util.ClassUtils;
import com.github.halab4dev.mongo2j.util.Validator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;

public class BsonSerializer {
    private static final String ID = "_id";

    public Document toDocument(Object object) {
        if (Validator.isNull(object)) {
            return null;
        }
        Document document = new Document();
        Class<?> clazz = object.getClass();
        List<Field> fields = ClassUtils.getSuperClassField(clazz);
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Field field : fields) {
            try {
                this.addDocumentField(document, field, object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return document;
    }

    private void addDocumentField(Document document, Field field, Object object) throws IllegalAccessException {
        field.setAccessible(true);
        if (Validator.isNull(field.get(object))) {
            return;
        }
        String fieldName = BsonUtils.getDocumentFieldName(field);
        if (field.isAnnotationPresent(BsonId.class)) {
            BsonId idAnnotation = field.getDeclaredAnnotation(BsonId.class);
            Class<?> type = idAnnotation.value();
            if (type == ObjectId.class) {
                ObjectId objectId = this.createObjectId(field.get(object), field.getType());
                document.append(ID, (Object)objectId);
            } else {
                document.append(ID, field.get(object));
            }
        } else if (ClassUtils.isSimpleValue(field)) {
            document.append(fieldName, field.get(object));
        } else if (ClassUtils.isDate(field)) {
            document.append(fieldName, field.get(object));
        } else if (ClassUtils.isCollection(field)) {
            document.append(fieldName, this.toDocumentList((Collection)field.get(object)));
        } else if (ClassUtils.isMap(field)) {
            Document subDocument = this.toDocument((Map)field.get(object));
            document.append(fieldName, (Object)subDocument);
        } else {
            Document subDocument = this.toDocument(field.get(object));
            document.append(fieldName, (Object)subDocument);
        }
    }

    private ObjectId createObjectId(Object value, Class<?> type) {
        if (type == ObjectId.class) {
            return (ObjectId)value;
        }
        if (type == String.class) {
            String id = (String)value;
            return new ObjectId(id);
        }
        throw new IllegalArgumentException("ID must be String or ObjectId type");
    }

    List<?> toDocumentList(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : collection) {
            if (ClassUtils.isWrappedClass(object)) {
                result.add(object);
                continue;
            }
            Document document = this.toDocument(object);
            result.add(document);
        }
        return result;
    }

    private Document toDocument(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Document document = new Document();
        map.forEach((key, value) -> {
            if (ClassUtils.isSimpleValue(value)) {
                document.append(key.toString(), value);
            } else {
                document.append(key.toString(), (Object)this.toDocument(value));
            }
        });
        return document;
    }
}

