/*
 * Decompiled with CFR 0.152.
 */
package com.github.halab4dev.mongo2j.util;

import com.github.halab4dev.mongo2j.util.Validator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class ClassUtils {
    private static final List<Class<?>> SIMPLE_VALUE_CLASSES = new ArrayList();

    private ClassUtils() {
    }

    public static boolean isSimpleValue(Field field) {
        Class<?> fieldClass = field.getType();
        return fieldClass.isPrimitive() || SIMPLE_VALUE_CLASSES.contains(fieldClass);
    }

    public static boolean isSimpleValue(Object object) {
        Class<?> fieldClass = object.getClass();
        return fieldClass.isPrimitive() || SIMPLE_VALUE_CLASSES.contains(fieldClass);
    }

    public static boolean isDate(Field field) {
        Class<Date> fieldClass = field.getType();
        return fieldClass.isAssignableFrom(Date.class);
    }

    public static boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    public static boolean isMap(Field field) {
        return Map.class.isAssignableFrom(field.getType());
    }

    public static boolean isWrappedClass(Object object) {
        return SIMPLE_VALUE_CLASSES.contains(object.getClass());
    }

    public static boolean isWrappedClass(Class clazz) {
        return SIMPLE_VALUE_CLASSES.contains(clazz);
    }

    public static List<Field> getSuperClassField(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class superClass = clazz.getSuperclass();
        if (Validator.isNotNull(superClass)) {
            fields.addAll(ClassUtils.getSuperClassField(superClass));
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        return fields;
    }

    static {
        SIMPLE_VALUE_CLASSES.add(String.class);
        SIMPLE_VALUE_CLASSES.add(Boolean.class);
        SIMPLE_VALUE_CLASSES.add(Character.class);
        SIMPLE_VALUE_CLASSES.add(Byte.class);
        SIMPLE_VALUE_CLASSES.add(Short.class);
        SIMPLE_VALUE_CLASSES.add(Integer.class);
        SIMPLE_VALUE_CLASSES.add(Long.class);
        SIMPLE_VALUE_CLASSES.add(Float.class);
        SIMPLE_VALUE_CLASSES.add(Double.class);
    }
}

