/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Precision;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class EPrecisionTest {
    @Test
    public void testCalculateIntegerMantissa() {
        Assertions.assertThat((int)((int)Precision.TENTHS.calculateIntegerMantissa(1.1))).isEqualTo(11);
        Assertions.assertThat((int)((int)Precision.THOUSANDTHS.calculateIntegerMantissa(1.122))).isEqualTo(1122);
        Assertions.assertThat((int)((int)Precision.HUNDREDS.calculateIntegerMantissa(100.122))).isEqualTo(1);
        Assertions.assertThat((double)Precision.HUNDREDS.calculateIntegerMantissa(9.223372036854776E18)).isNaN();
        Assertions.assertThat((double)Precision.HUNDREDS.calculateIntegerMantissa(-9.223372036854776E18)).isNaN();
    }

    @Test
    public void calculateDoubleFromIntegerMantissa() {
        Assertions.assertThat((double)Precision.TENTHS.calculateDoubleFromIntegerMantissa(11L)).isEqualTo(1.1);
        Assertions.assertThat((double)Precision.THOUSANDTHS.calculateDoubleFromIntegerMantissa(1122L)).isEqualTo(1.122);
        Assertions.assertThat((double)Precision.HUNDREDS.calculateDoubleFromIntegerMantissa(1L)).isEqualTo(100.0);
    }

    @Test
    public void testGetNbDigit() {
        Assertions.assertThat((int)Precision.TENTHS.getNbDigit()).isEqualTo(1);
    }

    @Test
    public void testGetPrecision() {
        Assertions.assertThat((double)Precision.TENTHS.getPrecision()).isEqualTo(0.1);
    }

    @Test
    public void testValueOfInt() {
        Assertions.assertThat((Object)Precision.valueOf((int)1)).isEqualTo((Object)Precision.TENTHS);
        Assertions.assertThat((Object)Precision.valueOf((int)-1)).isEqualTo((Object)Precision.TENS);
        try {
            Precision.valueOf((int)Integer.MAX_VALUE);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testValueOfDouble() {
        Assertions.assertThat((Object)Precision.valueOf((double)0.1)).isEqualTo((Object)Precision.TENTHS);
        Assertions.assertThat((Object)Precision.valueOf((double)10.0)).isEqualTo((Object)Precision.TENS);
        try {
            Precision.valueOf((double)Double.MAX_VALUE);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testValueOf() {
        Assertions.assertThat((Object)Precision.valueOf((String)"TENTHS")).isEqualTo((Object)Precision.TENTHS);
    }
}

