/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Scale;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ScaleTest {
    @Test
    public void testCalculateUnscaledValue() {
        Assertions.assertThat((int)((int)Scale.TENTHS.calculateUnscaledValue(1.1))).isEqualTo(11);
        Assertions.assertThat((int)((int)Scale.THOUSANDTHS.calculateUnscaledValue(1.122))).isEqualTo(1122);
        Assertions.assertThat((int)((int)Scale.HUNDREDS.calculateUnscaledValue(100.122))).isEqualTo(1);
        Assertions.assertThat((double)Scale.HUNDREDS.calculateUnscaledValue(9.223372036854776E18)).isNaN();
        Assertions.assertThat((double)Scale.HUNDREDS.calculateUnscaledValue(-9.223372036854776E18)).isNaN();
    }

    @Test
    public void calculateDoubleFromIntegerMantissa() {
        Assertions.assertThat((double)Scale.TENTHS.calculateDoubleFromUnscaledValue(11L)).isEqualTo(1.1);
        Assertions.assertThat((double)Scale.THOUSANDTHS.calculateDoubleFromUnscaledValue(1122L)).isEqualTo(1.122);
        Assertions.assertThat((double)Scale.HUNDREDS.calculateDoubleFromUnscaledValue(1L)).isEqualTo(100.0);
    }

    @Test
    public void testGetScale() {
        Assertions.assertThat((int)Scale.TENTHS.getScale()).isEqualTo(1);
    }

    @Test
    public void testGetDecimal() {
        Assertions.assertThat((double)Scale.TENTHS.getDecimal()).isEqualTo(0.1);
    }

    @Test
    public void testValueOfInt() {
        Assertions.assertThat((Object)Scale.valueOf((int)1)).isEqualTo((Object)Scale.TENTHS);
        Assertions.assertThat((Object)Scale.valueOf((int)-1)).isEqualTo((Object)Scale.TENS);
        try {
            Scale.valueOf((int)Integer.MAX_VALUE);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testValueOfDouble() {
        Assertions.assertThat((Object)Scale.valueOf((double)0.1)).isEqualTo((Object)Scale.TENTHS);
        Assertions.assertThat((Object)Scale.valueOf((double)10.0)).isEqualTo((Object)Scale.TENS);
        try {
            Scale.valueOf((double)Double.MAX_VALUE);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testValueOf() {
        Assertions.assertThat((Object)Scale.valueOf((String)"TENTHS")).isEqualTo((Object)Scale.TENTHS);
    }
}

